<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right"><a href="<?php echo $add; ?>" data-toggle="tooltip" title="<?php echo $button_add; ?>" class="btn btn-primary"><i class="fa fa-plus"></i></a>
				<button type="button" data-toggle="tooltip" title="<?php echo $button_copy; ?>" class="btn btn-default" onclick="$('#form-product').attr('action', '<?php echo $copy; ?>').submit()"><i class="fa fa-copy"></i></button>
				<button type="button" data-toggle="tooltip" title="<?php echo $button_delete; ?>" class="btn btn-danger" onclick="confirm('<?php echo $text_confirm; ?>') ? $('#form-product').submit() : false;"><i class="fa fa-trash-o"></i></button>
			</div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<?php if ($success) { ?>
		<div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-list"></i> <?php echo $text_list; ?></h3>
			</div>

			<div class="panel-body">
				<div class="well">
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<label class="control-label" for="input-name"><?php echo $entry_name; ?></label>
								<input type="text" name="filter_name" value="<?php echo $filter_name; ?>" placeholder="<?php echo $entry_name; ?>" id="input-name" class="form-control" />
							</div>
							<div class="form-group">
								<label class="control-label" for="input-model"><?php echo $entry_model; ?></label>
								<input type="text" name="filter_model" value="<?php echo $filter_model; ?>" placeholder="<?php echo $entry_model; ?>" id="input-model" class="form-control" />
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<label class="control-label" for="input-price"><?php echo $entry_price; ?></label>
								<input type="text" name="filter_price" value="<?php echo $filter_price; ?>" placeholder="<?php echo $entry_price; ?>" id="input-price" class="form-control" />
							</div>
							<div class="form-group">
								<label class="control-label" for="input-quantity"><?php echo $entry_quantity; ?></label>
								<input type="text" name="filter_quantity" value="<?php echo $filter_quantity; ?>" placeholder="<?php echo $entry_quantity; ?>" id="input-quantity" class="form-control" />
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<label class="control-label" for="input-status"><?php echo $entry_status; ?></label>
								<select name="filter_status" id="input-status" class="form-control">
									<option value="*"></option>
									<?php if ($filter_status) { ?>
									<option value="1" selected="selected"><?php echo $text_enabled; ?></option>
									<?php } else { ?>
									<option value="1"><?php echo $text_enabled; ?></option>
									<?php } ?>
									<?php if (!$filter_status && !is_null($filter_status)) { ?>
									<option value="0" selected="selected"><?php echo $text_disabled; ?></option>
									<?php } else { ?>
									<option value="0"><?php echo $text_disabled; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="form-group">
								<label class="control-label" for="input-status"><?php echo $column_category; ?></label>
								<select name="filter_category" id="input-status" class="form-control">
								<option value="*"></option>
								<?php foreach ($categories as $category) { ?>
									<?php if ($category['category_id']==$filter_category) { ?>
										<option value="<?php echo $category['category_id']; ?>" selected="selected"><?php echo $category['name']; ?></option>
									<?php } else { ?>
										<option value="<?php echo $category['category_id']; ?>"><?php echo $category['name']; ?></option>
									<?php } ?>
								<?php } ?>
								</select>
							</div>
							<button type="button" id="button-filter" class="btn btn-primary pull-right"><i class="fa fa-search"></i> <?php echo $button_filter; ?></button>
						</div>
					</div>
				</div>
				<form action="<?php echo $delete; ?>" method="post" enctype="multipart/form-data" id="form-product">
					<div class="table-responsive">
						<table class="table table-bordered table-hover">
							<thead>
								<tr>
									<td style="width: 1px;" class="text-center"><input type="checkbox" onclick="$('input[name*=\'selected\']').prop('checked', this.checked);" /></td>
									<td class="text-center"><?php echo $column_image; ?></td>
									<td class="text-left"><?php if ($sort == 'pd.name') { ?>
										<a href="<?php echo $sort_name; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_name; ?></a>
										<?php } else { ?>
										<a href="<?php echo $sort_name; ?>"><?php echo $column_name; ?></a>
										<?php } ?></td>
									<td class="text-left"><?php if ($sort == 'p.model') { ?>
										<a href="<?php echo $sort_model; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_model; ?></a>
										<?php } else { ?>
										<a href="<?php echo $sort_model; ?>"><?php echo $column_model; ?></a>
										<?php } ?></td>
									<td class="text-right"><?php if ($sort == 'p.price') { ?>
										<a href="<?php echo $sort_price; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_price; ?></a>
										<?php } else { ?>
										<a href="<?php echo $sort_price; ?>"><?php echo $column_price; ?></a>
										<?php } ?></td>
									<td class="text-left"><?php echo $column_category; ?></td>
									<td class="text-right"><?php if ($sort == 'p.quantity') { ?>
										<a href="<?php echo $sort_quantity; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_quantity; ?></a>
										<?php } else { ?>
										<a href="<?php echo $sort_quantity; ?>"><?php echo $column_quantity; ?></a>
										<?php } ?></td>
									<td class="text-left"><?php if ($sort == 'p.status') { ?>
										<a href="<?php echo $sort_status; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_status; ?></a>
										<?php } else { ?>
										<a href="<?php echo $sort_status; ?>"><?php echo $column_status; ?></a>
										<?php } ?></td>
									<td class="text-right"><?php echo $column_action; ?></td>
								</tr>
							</thead>
							<tbody>
								<?php if ($products) { ?>
								<?php foreach ($products as $product) { ?>
								<tr>
									<td class="text-center"><?php if (in_array($product['product_id'], $selected)) { ?>
										<input type="checkbox" name="selected[]" value="<?php echo $product['product_id']; ?>" checked="checked" />
										<?php } else { ?>
										<input type="checkbox" name="selected[]" value="<?php echo $product['product_id']; ?>" />
										<?php } ?></td>
									<td class="text-center"><?php if ($product['image']) { ?>
										<img src="<?php echo $product['image']; ?>" alt="<?php echo $product['name']; ?>" class="img-thumbnail" />
										<?php } else { ?>
										<span class="img-thumbnail list"><i class="fa fa-camera fa-2x"></i></span>
										<?php } ?></td>
									<td class="text-left"><?php echo $product['name']; ?></td>
									<td class="text-left"><?php echo $product['model']; ?></td>
									<td class="text-right edit-price edit-price-closed">

										<div class="edit-price-view">
											<?php if ($product['special']) { ?>
												<span style="text-decoration: line-through;"><span class="price-normal"><?php echo $product['price']; ?></span></span><br/>
												<div class="text-danger"><span class="price-special"><?php echo $product['special']; ?></span></div>
											<?php } else { ?>
												<span class="price-normal"><?php echo $product['price']; ?></span>
											<?php } ?>
										</div>

										<div class="edit-price-form text-left form-horizontal">
											<div class="form-group form-group-sm">
												<label class="control-label col-sm-6">Preço base:</label>
												<div class="control-input col-sm-6">
													<input type="text" name="price" value="<?php echo $product['price']; ?>" class="form-control" />
												</div>
											</div>
											<?php foreach($product['specials'] as $special){ ?>
												<?php if ($special['date_end'] == '0000-00-00' || $special['date_end'] >= date('Y-m-d')) { ?>
													<div class="form-group form-group-sm">
														<label class="control-label col-sm-6">Promoção <?php echo $customer_groups[$special['customer_group_id']]; ?>:</label>
														<div class="control-input col-sm-6">
															<input type="text" name="special[<?php echo $special['product_special_id']; ?>]" value="<?php echo $special['price']; ?>" class="form-control" />
														</div>
													</div>
												<?php } ?>
											<?php } ?>
											<?php foreach($product['discounts'] as $discount){ ?>
												<?php if ($discount['date_end'] == '0000-00-00' || $discount['date_end'] >= date('Y-m-d')) { ?>
													<div class="form-group form-group-sm">
														<label class="control-label col-sm-6">Desconto <?php echo $customer_groups[$discount['customer_group_id']]; ?> (Qtd <?php echo $discount['quantity']; ?>+):</label>
														<div class="control-input col-sm-6">
															<input type="text" name="discount[<?php echo $discount['product_discount_id']; ?>]" value="<?php echo $discount['price']; ?>" class="form-control" />
														</div>
													</div>
												<?php } ?>
											<?php } ?>
											<div class="pull-right">
												<a data-toggle="tooltip" title="Salvar" class="edit-price-btn-save btn btn-primary"><i class="fa fa-floppy-o"></i></a> &nbsp;
												<a data-toggle="tooltip" title="Cancelar" class="edit-price-btn-cancel btn btn-danger"><i class="fa fa-times"></i></a>
											</div>
										</div>

									</td>
									<td class="text-left">
										<?php foreach ($categories as $category) { ?>
										<?php if (in_array($category['category_id'], $product['category'])) { ?><?php echo $category['name'];?><br><?php } ?>
										<?php } ?></td>
									<td class="text-right"><?php if ($product['quantity'] <= 0) { ?>
										<span class="label label-warning"><?php echo $product['quantity']; ?></span>
										<?php } elseif ($product['quantity'] <= 5) { ?>
										<span class="label label-danger"><?php echo $product['quantity']; ?></span>
										<?php } else { ?>
										<span class="label label-success"><?php echo $product['quantity']; ?></span>
										<?php } ?></td>
									<td class="text-left"><?php echo $product['status']; ?></td>
									<td class="text-right"><a href="<?php echo $product['edit']; ?>" data-toggle="tooltip" title="<?php echo $button_edit; ?>" class="btn btn-primary"><i class="fa fa-pencil"></i></a></td>
								</tr>
								<?php } ?>
								<?php } else { ?>
								<tr>
									<td class="text-center" colspan="8"><?php echo $text_no_results; ?></td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
				</form>
				<div class="row">
					<div class="col-sm-6 text-left"><?php echo $pagination; ?></div>
					<div class="col-sm-6 text-right"><?php echo $results; ?></div>
				</div>
			</div>

		</div>

	</div>
	<script type="text/javascript"><!--
$('#button-filter').on('click', function() {
	var url = 'index.php?route=catalog/product&token=<?php echo $token; ?>';

	var filter_name = $('input[name=\'filter_name\']').val();

	if (filter_name) {
		url += '&filter_name=' + encodeURIComponent(filter_name);
	}

	var filter_model = $('input[name=\'filter_model\']').val();

	if (filter_model) {
		url += '&filter_model=' + encodeURIComponent(filter_model);
	}

	var filter_price = $('input[name=\'filter_price\']').val();

	if (filter_price) {
		url += '&filter_price=' + encodeURIComponent(filter_price);
	}

	var filter_category = $('select[name=\'filter_category\']').val();

	if (filter_category != '*') {
		url += '&filter_category=' + encodeURIComponent(filter_category);
	}

	var filter_quantity = $('input[name=\'filter_quantity\']').val();

	if (filter_quantity) {
		url += '&filter_quantity=' + encodeURIComponent(filter_quantity);
	}

	var filter_status = $('select[name=\'filter_status\']').val();

	if (filter_status != '*') {
		url += '&filter_status=' + encodeURIComponent(filter_status);
	}

	location = url;
});
//--></script>
	<script type="text/javascript"><!--
$('input[name=\'filter_name\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/product/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						label: item['name'],
						value: item['product_id']
					}
				}));
			}
		});
	},
	'select': function(item) {
		$('input[name=\'filter_name\']').val(item['label']);
	}
});

$('input[name=\'filter_model\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/product/autocomplete&token=<?php echo $token; ?>&filter_model=' +  encodeURIComponent(request),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						label: item['model'],
						value: item['product_id']
					}
				}));
			}
		});
	},
	'select': function(item) {
		$('input[name=\'filter_model\']').val(item['label']);
	}
});
//--></script></div>



<style>
.edit-price {
	position: relative;
}
.edit-price-closed {
	cursor: pointer;
}
.edit-price-closed:hover:after {
	position: absolute;
	top: 10px;
	left: 10px;
	content: "\f040";
	font: normal normal normal 14px/1 FontAwesome;
	text-rendering: auto;
	-webkit-font-smoothing: antialiased;
	-moz-osx-font-smoothing: grayscale;
}

.edit-price-form {
	display: none;
	min-width: 150px;
}
.edit-price-form .form-group-sm .control-label {
	padding-right: 3px;
	font-size: 11px;
}
.edit-price-form .form-group-sm .control-input {
	padding-left: 3px;
}

.edit-price-loading {
	position: absolute;
	right: 107px;
	bottom: 14px;
	font-size: 21px;
}
</style>

<script>
(function(){
	'use strict';

	var $list = $('#form-product').find('.table tbody');

	$list.on('click', '.edit-price', function(e){
		var $this = $(this);

		if ($this.hasClass('edit-price-closed')) {
			$this.removeClass('edit-price-closed');
			$this.addClass('edit-price-open');
			$this.find('.edit-price-view').slideUp();
			$this.find('.edit-price-form').slideDown();
		}
	});

	$list.on('click', '.edit-price-btn-cancel', function(e){
		e.preventDefault();
		e.stopPropagation();

		var $this = $(this);
		var $parent = $this.parents('.edit-price');

		$parent.removeClass('edit-price-open');
		$parent.addClass('edit-price-closed');
		$parent.find('.edit-price-view').slideDown();
		$parent.find('.edit-price-form').slideUp();
	});

	$list.on('click', '.edit-price-btn-save', function(e){
		e.preventDefault();
		e.stopPropagation();

		var $this = $(this);

		if ($this.data('saving')) {
			return false;
		}

		$this.data('saving', true);

		var $parent = $this.parents('.edit-price');
		var $row = $parent.parent();
		var id = $row.find('input[name^=selected]').val();

		var $view = $parent.find('.edit-price-view');
		var $form = $parent.find('.edit-price-form');

		var queryString = 'id=' + id + '&' + $form.find(':input').serialize();

		// GRAVAR E ATUALIZAR PREÇO NA LISTA
		$.ajax({
			url: 'index.php?route=catalog/product/edit_price&token=<?php echo $this->registry->get('session')->data['token']; ?>',
			type: 'post',
			data: queryString,
			dataType: 'json',
			beforeSend: function() {
				$form.append('<i class="edit-price-loading fa fa-spinner fa-pulse fa-fw"></i>');
			},
			complete: function() {
				$this.data('saving', false);
				$form.find('.edit-price-loading').remove();
			},
			success: function(json) {
				if (json.price) {
					$view.find('.price-normal').html(json.price);
				}

				if (json.special) {
					$view.find('.price-special').html(json.special);
				}

				$parent.removeClass('edit-price-open');
				$parent.addClass('edit-price-closed');

				$form.slideUp();
				$view.slideDown();
			},
			error: function(jqXHR, textStatus, errorThrown) {
				alert('Ops, ocorreu um erro e não foi possível completar a operação.\n\n'+ errorThrown);
			}
		});

	});

})();
</script>



<?php echo $footer; ?>