<?php

$admin_username = $this->registry->get('user')->getUserName();

?>
<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">

			<div class="pull-right">
				<?php if (isset($pidqs) && $pidqs) { ?>
				<button id="qsave" style="margin: 0 20px;" data-toggle="tooltip" title="Salvar e continuar editando" class="btn btn-warning"><i class="fa fa-edit"></i></button>
				<?php } ?>
				<button type="submit" form="form-product" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a>
			</div>

			<h1><?php echo $heading_title; ?></h1>

			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>

		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">

			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_form; ?></h3>
			</div>

			<div class="panel-body">

				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-product" class="form-horizontal">



					<ul class="nav nav-tabs">
						<li class="active"><a href="#tab-general" data-toggle="tab"><?php echo $tab_general; ?></a></li>
						<li><a href="#tab-data" data-toggle="tab"><?php echo $tab_data; ?></a></li>
						<li><a href="#tab-stock" data-toggle="tab"><?php echo $tab_stock; ?></a></li>
						<li><a href="#tab-links" data-toggle="tab"><?php echo $tab_links; ?></a></li>
						<li><a href="#tab-option" data-toggle="tab"><?php echo $tab_option; ?></a></li>
						<li id="tab-combination-link"><a href="#tab-combination" data-toggle="tab"><?php echo $tab_combinations; ?></a></li>
						<li><a href="#tab-attribute" data-toggle="tab"><?php echo $tab_attribute; ?></a></li>
						<li <?php if ($admin_username != 'devhdw') { echo('style="display: none;"'); } ?> ><a href="#tab-recurring" data-toggle="tab"><?php echo $tab_recurring; ?></a></li>
						<li><a href="#tab-discount" data-toggle="tab"><?php echo $tab_discount; ?></a></li>
						<li><a href="#tab-special" data-toggle="tab"><?php echo $tab_special; ?></a></li>
						<li><a href="#tab-image" data-toggle="tab"><?php echo $tab_image; ?></a></li>
						<li><a href="#tab-reward" data-toggle="tab"><?php echo $tab_reward; ?></a></li>
						<li <?php if ($admin_username != 'devhdw') { echo('style="display: none;"'); } ?> ><a href="#tab-design" data-toggle="tab"><?php echo $tab_design; ?></a></li>
					</ul>

					<div class="tab-content">



						<div class="tab-pane active" id="tab-general">
							<ul class="nav nav-tabs" id="language">
								<?php foreach ($languages as $language) { ?>
								<li><a href="#language<?php echo $language['language_id']; ?>" data-toggle="tab"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /> <?php echo $language['name']; ?></a></li>
								<?php } ?>
							</ul>
							<div class="tab-content">
								<?php foreach ($languages as $language) { ?>
								<div class="tab-pane" id="language<?php echo $language['language_id']; ?>">
									<div class="form-group required">
										<label class="col-sm-2 control-label" for="input-name<?php echo $language['language_id']; ?>"><?php echo $entry_name; ?></label>
										<div class="col-sm-10">
											<input type="text" name="product_description[<?php echo $language['language_id']; ?>][name]" value="<?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['name'] : ''; ?>" placeholder="<?php echo $entry_name; ?>" id="input-name<?php echo $language['language_id']; ?>" class="form-control input-name" />
											<?php if (isset($error_name[$language['language_id']])) { ?>
											<div class="text-danger"><?php echo $error_name[$language['language_id']]; ?></div>
											<?php } ?>
										</div>
									</div>
									<div class="form-group">
										<label class="col-sm-2 control-label" for="input-description<?php echo $language['language_id']; ?>"><span data-toggle="tooltip" title="<?php echo $help_description; ?>"><?php echo $entry_description; ?></span></label>
										<div class="col-sm-10">
											<textarea name="product_description[<?php echo $language['language_id']; ?>][description]" placeholder="<?php echo $entry_description; ?>" id="input-description<?php echo $language['language_id']; ?>"><?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['description'] : ''; ?></textarea>
										</div>
									</div>
									<div class="form-group required">
										<label class="col-sm-2 control-label" for="input-meta-title<?php echo $language['language_id']; ?>"><span data-toggle="tooltip" title="<?php echo $help_meta_title; ?>"><?php echo $entry_meta_title; ?></span></label>
										<div class="col-sm-10">
											<input type="text" name="product_description[<?php echo $language['language_id']; ?>][meta_title]" value="<?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['meta_title'] : ''; ?>" placeholder="<?php echo $entry_meta_title; ?>" id="input-meta-title<?php echo $language['language_id']; ?>" class="form-control input-meta-title" />
											<?php if (isset($error_meta_title[$language['language_id']])) { ?>
											<div class="text-danger"><?php echo $error_meta_title[$language['language_id']]; ?></div>
											<?php } ?>
										</div>
									</div>
									<div class="form-group">
										<label class="col-sm-2 control-label" for="input-meta-description<?php echo $language['language_id']; ?>"><span data-toggle="tooltip" title="<?php echo $help_meta_description; ?>"><?php echo $entry_meta_description; ?></span></label>
										<div class="col-sm-10">
											<textarea name="product_description[<?php echo $language['language_id']; ?>][meta_description]" rows="5" placeholder="<?php echo $entry_meta_description; ?>" id="input-meta-description<?php echo $language['language_id']; ?>" class="form-control"><?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['meta_description'] : ''; ?></textarea>
										</div>
									</div>
									<div class="form-group">
										<label class="col-sm-2 control-label" for="input-meta-keyword<?php echo $language['language_id']; ?>"><span data-toggle="tooltip" title="<?php echo $help_meta_keyword; ?>"><?php echo $entry_meta_keyword; ?></span></label>
										<div class="col-sm-10">
											<textarea name="product_description[<?php echo $language['language_id']; ?>][meta_keyword]" rows="5" placeholder="<?php echo $entry_meta_keyword; ?>" id="input-meta-keyword<?php echo $language['language_id']; ?>" class="form-control"><?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['meta_keyword'] : ''; ?></textarea>
										</div>
									</div>
									<div class="form-group">
										<label class="col-sm-2 control-label" for="input-tag<?php echo $language['language_id']; ?>"><span data-toggle="tooltip" title="<?php echo $help_tag; ?>"><?php echo $entry_tag; ?></span></label>
										<div class="col-sm-10">
											<input type="text" name="product_description[<?php echo $language['language_id']; ?>][tag]" value="<?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['tag'] : ''; ?>" placeholder="<?php echo $entry_tag; ?>" id="input-tag<?php echo $language['language_id']; ?>" class="form-control" />
										</div>
									</div>
								</div>
								<?php } ?>
							</div>
						</div><!-- #tab-general -->



						<div class="tab-pane" id="tab-data">
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-image"><?php echo $entry_image_main; ?></label>
								<div class="col-sm-10">
									<a href="" id="thumb-image" data-toggle="image" class="img-thumbnail"><img src="<?php echo $thumb; ?>" alt="" title="" data-placeholder="<?php echo $placeholder; ?>" /></a>
									<input type="hidden" name="image" value="<?php echo $image; ?>" id="input-image" />
								</div>
							</div>
							<div class="form-group required">
								<label class="col-sm-2 control-label" for="input-model"><span data-toggle="tooltip" title="<?php echo $help_model; ?>"><?php echo $entry_model; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="model" value="<?php echo $model; ?>" placeholder="<?php echo $entry_model; ?>" id="input-model" class="form-control" />
									<?php if ($error_model) { ?>
									<div class="text-danger"><?php echo $error_model; ?></div>
									<?php } ?>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-price"><?php echo $entry_price_base; ?></label>
								<div class="col-sm-10">
									<input type="text" name="price" value="<?php echo $price; ?>" placeholder="<?php echo $entry_price; ?>" id="input-price" class="form-control" />
								</div>
							</div>
							<div class="form-group" style="display:none">
								<label class="col-sm-2 control-label" for="input-tax-class"><?php echo $entry_tax_class; ?></label>
								<div class="col-sm-10">
									<select name="tax_class_id" id="input-tax-class" class="form-control">
										<option value="0"><?php echo $text_none; ?></option>
										<?php foreach ($tax_classes as $tax_class) { ?>
										<?php if ($tax_class['tax_class_id'] == $tax_class_id) { ?>
										<option value="<?php echo $tax_class['tax_class_id']; ?>" selected="selected"><?php echo $tax_class['title']; ?></option>
										<?php } else { ?>
										<option value="<?php echo $tax_class['tax_class_id']; ?>"><?php echo $tax_class['title']; ?></option>
										<?php } ?>
										<?php } ?>
									</select>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $help_shipping; ?>"><?php echo $entry_shipping; ?></span></label>
								<div class="col-sm-10">
									<label class="radio-inline">
										<?php if ($shipping) { ?>
										<input type="radio" name="shipping" value="1" checked="checked" />
										<?php echo $text_yes; ?>
										<?php } else { ?>
										<input type="radio" name="shipping" value="1" />
										<?php echo $text_yes; ?>
										<?php } ?>
									</label>
									<label class="radio-inline">
										<?php if (!$shipping) { ?>
										<input type="radio" name="shipping" value="0" checked="checked" />
										<?php echo $text_no; ?>
										<?php } else { ?>
										<input type="radio" name="shipping" value="0" />
										<?php echo $text_no; ?>
										<?php } ?>
									</label>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-length"><span data-toggle="tooltip" title="<?php echo $help_dimension; ?>"><?php echo $entry_dimension; ?></span></label>
								<div class="col-sm-10">
									<div class="row">
										<div class="col-sm-4">
											<input type="text" name="length" value="<?php echo $length; ?>" placeholder="<?php echo $entry_length; ?>" id="input-length" class="form-control" />
										</div>
										<div class="col-sm-4">
											<input type="text" name="width" value="<?php echo $width; ?>" placeholder="<?php echo $entry_width; ?>" id="input-width" class="form-control" />
										</div>
										<div class="col-sm-4">
											<input type="text" name="height" value="<?php echo $height; ?>" placeholder="<?php echo $entry_height; ?>" id="input-height" class="form-control" />
										</div>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-length-class"><?php echo $entry_length_class; ?></label>
								<div class="col-sm-10">
									<select name="length_class_id" id="input-length-class" class="form-control">
										<?php foreach ($length_classes as $length_class) { ?>
										<?php if ($length_class['length_class_id'] == $length_class_id) { ?>
										<option value="<?php echo $length_class['length_class_id']; ?>" selected="selected"><?php echo $length_class['title']; ?></option>
										<?php } else { ?>
										<option value="<?php echo $length_class['length_class_id']; ?>"><?php echo $length_class['title']; ?></option>
										<?php } ?>
										<?php } ?>
									</select>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-weight"><span data-toggle="tooltip" title="<?php echo $help_weight; ?>"><?php echo $entry_weight; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="weight" value="<?php echo $weight; ?>" placeholder="<?php echo $entry_weight; ?>" id="input-weight" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-weight-class"><?php echo $entry_weight_class; ?></label>
								<div class="col-sm-10">
									<select name="weight_class_id" id="input-weight-class" class="form-control">
										<?php foreach ($weight_classes as $weight_class) { ?>
										<?php if ($weight_class['weight_class_id'] == $weight_class_id) { ?>
										<option value="<?php echo $weight_class['weight_class_id']; ?>" selected="selected"><?php echo $weight_class['title']; ?></option>
										<?php } else { ?>
										<option value="<?php echo $weight_class['weight_class_id']; ?>"><?php echo $weight_class['title']; ?></option>
										<?php } ?>
										<?php } ?>
									</select>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-date-available"><?php echo $entry_date_available; ?></label>
								<div class="col-sm-3">
									<div class="input-group date">
										<input type="text" name="date_available" value="<?php echo $date_available; ?>" placeholder="<?php echo $entry_date_available; ?>" data-date-format="YYYY-MM-DD" id="input-date-available" class="form-control" />
										<span class="input-group-btn">
										<button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button>
										</span></div>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
								<div class="col-sm-10">
									<select name="status" id="input-status" class="form-control">
										<?php if ($status) { ?>
										<option value="1" selected="selected"><?php echo $text_enabled; ?></option>
										<option value="0"><?php echo $text_disabled; ?></option>
										<?php } else { ?>
										<option value="1"><?php echo $text_enabled; ?></option>
										<option value="0" selected="selected"><?php echo $text_disabled; ?></option>
										<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
								<div class="col-sm-10">
									<input type="text" name="sort_order" value="<?php echo $sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
								</div>
							</div>
						</div><!-- #tab-data -->



						<div class="tab-pane" id="tab-stock">
							<div class="form-group stock-quantity">
								<label class="col-sm-2 control-label" for="input-quantity"><span data-toggle="tooltip" title="<?php echo $help_quantity_stock; ?>"><?php echo $entry_quantity_stock; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="quantity" value="<?php echo $quantity; ?>" placeholder="<?php echo $entry_quantity; ?>" id="input-quantity" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-minimum"><span data-toggle="tooltip" title="<?php echo $help_minimum; ?>"><?php echo $entry_minimum; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="minimum" value="<?php echo $minimum; ?>" placeholder="<?php echo $entry_minimum; ?>" id="input-minimum" class="form-control" />
								</div>
							</div>
							<div class="form-group stock-subtract">
								<label class="col-sm-2 control-label" for="input-subtract"><span data-toggle="tooltip" title="<?php echo $help_subtract; ?>"><?php echo $entry_subtract; ?></span></label>
								<div class="col-sm-10">
									<select name="subtract" id="input-subtract" class="form-control">
										<?php if ($subtract) { ?>
										<option value="1" selected="selected"><?php echo $text_yes; ?></option>
										<option value="0"><?php echo $text_no; ?></option>
										<?php } else { ?>
										<option value="1"><?php echo $text_yes; ?></option>
										<option value="0" selected="selected"><?php echo $text_no; ?></option>
										<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-in-stock-status"><span data-toggle="tooltip" title="<?php echo $help_in_stock_status; ?>"><?php echo $entry_in_stock_status; ?></span></label>
								<div class="col-sm-10">
									<select name="in_stock_status_id" id="input-in-stock-status" class="form-control">
										<option value="0"></option>
										<?php foreach ($stock_statuses as $stock_status) { ?>
										<?php if ($stock_status['stock_status_id'] == $in_stock_status_id) { ?>
										<option value="<?php echo $stock_status['stock_status_id']; ?>" selected="selected"><?php echo $stock_status['name']; ?></option>
										<?php } else { ?>
										<option value="<?php echo $stock_status['stock_status_id']; ?>"><?php echo $stock_status['name']; ?></option>
										<?php } ?>
										<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-stock-status"><span data-toggle="tooltip" title="<?php echo $help_stock_status; ?>"><?php echo $entry_stock_status; ?></span></label>
								<div class="col-sm-10">
									<select name="stock_status_id" id="input-stock-status" class="form-control">
										<?php foreach ($stock_statuses as $stock_status) { ?>
										<?php if ($stock_status['stock_status_id'] == $stock_status_id) { ?>
										<option value="<?php echo $stock_status['stock_status_id']; ?>" selected="selected"><?php echo $stock_status['name']; ?></option>
										<?php } else { ?>
										<option value="<?php echo $stock_status['stock_status_id']; ?>"><?php echo $stock_status['name']; ?></option>
										<?php } ?>
										<?php } ?>
									</select>
								</div>
							</div>

							<br>

							<div class="form-group stock-sku">
								<label class="col-sm-2 control-label" for="input-sku"><span data-toggle="tooltip" title="<?php echo $help_sku; ?>"><?php echo $entry_sku; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="sku" value="<?php echo $sku; ?>" placeholder="<?php echo $entry_sku; ?>" id="input-sku" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-upc"><span data-toggle="tooltip" title="<?php echo $help_upc; ?>"><?php echo $entry_upc; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="upc" value="<?php echo $upc; ?>" placeholder="<?php echo $entry_upc; ?>" id="input-upc" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-ean"><span data-toggle="tooltip" title="<?php echo $help_ean; ?>"><?php echo $entry_ean; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="ean" value="<?php echo $ean; ?>" placeholder="<?php echo $entry_ean; ?>" id="input-ean" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-jan"><span data-toggle="tooltip" title="<?php echo $help_jan; ?>"><?php echo $entry_jan; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="jan" value="<?php echo $jan; ?>" placeholder="<?php echo $entry_jan; ?>" id="input-jan" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-isbn"><span data-toggle="tooltip" title="<?php echo $help_isbn; ?>"><?php echo $entry_isbn; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="isbn" value="<?php echo $isbn; ?>" placeholder="<?php echo $entry_isbn; ?>" id="input-isbn" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-mpn"><span data-toggle="tooltip" title="<?php echo $help_mpn; ?>"><?php echo $entry_mpn; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="mpn" value="<?php echo $mpn; ?>" placeholder="<?php echo $entry_mpn; ?>" id="input-mpn" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-location"><span data-toggle="tooltip" title="<?php echo $help_location; ?>"><?php echo $entry_location; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="location" value="<?php echo $location; ?>" placeholder="<?php echo $entry_location; ?>" id="input-location" class="form-control" />
								</div>
							</div>
						</div><!-- #tab-stock -->



						<div class="tab-pane" id="tab-links">
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-keyword"><span data-toggle="tooltip" title="<?php echo $help_keyword; ?>"><?php echo $entry_keyword; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="keyword" value="<?php echo $keyword; ?>" placeholder="<?php echo $entry_keyword; ?>" id="input-keyword" class="form-control" />
									<?php if ($error_keyword) { ?>
									<div class="text-danger"><?php echo $error_keyword; ?></div>
									<?php } ?>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-manufacturer"><span data-toggle="tooltip" title="<?php echo $help_manufacturer; ?>"><?php echo $entry_manufacturer; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="manufacturer" value="<?php echo $manufacturer ?>" placeholder="<?php echo $entry_manufacturer; ?>" id="input-manufacturer" class="form-control" />
									<input type="hidden" name="manufacturer_id" value="<?php echo $manufacturer_id; ?>" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-category"><span data-toggle="tooltip" title="<?php echo $help_category; ?>"><?php echo $entry_category; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="category" value="" placeholder="<?php echo $entry_category; ?>" id="input-category" class="form-control" />
									<div id="product-category" class="well well-sm" style="height: 150px; overflow: auto;">
										<?php foreach ($product_categories as $product_category) { ?>
										<div id="product-category<?php echo $product_category['category_id']; ?>"><i class="fa fa-minus-circle"></i> <?php echo $product_category['name']; ?>
											<input type="hidden" name="product_category[]" value="<?php echo $product_category['category_id']; ?>" />
										</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-filter"><span data-toggle="tooltip" title="<?php echo $help_filter; ?>"><?php echo $entry_filter; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="filter" value="" placeholder="<?php echo $entry_filter; ?>" id="input-filter" class="form-control" />
									<div id="product-filter" class="well well-sm" style="height: 150px; overflow: auto;">
										<?php foreach ($product_filters as $product_filter) { ?>
										<div id="product-filter<?php echo $product_filter['filter_id']; ?>"><i class="fa fa-minus-circle"></i> <?php echo $product_filter['name']; ?>
											<input type="hidden" name="product_filter[]" value="<?php echo $product_filter['filter_id']; ?>" />
										</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<div class="form-group" <?php if ($admin_username != 'devhdw') { echo('style="display: none;"'); } ?> >
								<label class="col-sm-2 control-label"><?php echo $entry_store; ?></label>
								<div class="col-sm-10">
									<div class="well well-sm" style="height: 150px; overflow: auto;">
										<div class="checkbox">
											<label>
												<?php if (in_array(0, $product_store)) { ?>
												<input type="checkbox" name="product_store[]" value="0" checked="checked" />
												<?php echo $text_default; ?>
												<?php } else { ?>
												<input type="checkbox" name="product_store[]" value="0" />
												<?php echo $text_default; ?>
												<?php } ?>
											</label>
										</div>
										<?php foreach ($stores as $store) { ?>
										<div class="checkbox">
											<label>
												<?php if (in_array($store['store_id'], $product_store)) { ?>
												<input type="checkbox" name="product_store[]" value="<?php echo $store['store_id']; ?>" checked="checked" />
												<?php echo $store['name']; ?>
												<?php } else { ?>
												<input type="checkbox" name="product_store[]" value="<?php echo $store['store_id']; ?>" />
												<?php echo $store['name']; ?>
												<?php } ?>
											</label>
										</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-download"><span data-toggle="tooltip" title="<?php echo $help_download; ?>"><?php echo $entry_download; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="download" value="" placeholder="<?php echo $entry_download; ?>" id="input-download" class="form-control" />
									<div id="product-download" class="well well-sm" style="height: 150px; overflow: auto;">
										<?php foreach ($product_downloads as $product_download) { ?>
										<div id="product-download<?php echo $product_download['download_id']; ?>"><i class="fa fa-minus-circle"></i> <?php echo $product_download['name']; ?>
											<input type="hidden" name="product_download[]" value="<?php echo $product_download['download_id']; ?>" />
										</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-related"><span data-toggle="tooltip" title="<?php echo $help_related; ?>"><?php echo $entry_related; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="related" value="" placeholder="<?php echo $entry_related; ?>" id="input-related" class="form-control" />
									<div id="product-related" class="well well-sm" style="height: 150px; overflow: auto;">
										<?php foreach ($product_relateds as $product_related) { ?>
										<div id="product-related<?php echo $product_related['product_id']; ?>"><i class="fa fa-minus-circle"></i> <?php echo $product_related['name']; ?>
											<input type="hidden" name="product_related[]" value="<?php echo $product_related['product_id']; ?>" />
										</div>
										<?php } ?>
									</div>
								</div>
							</div>
						</div><!-- #tab-links -->



						<div class="tab-pane" id="tab-option">
							<div class="row">

								<div class="col-sm-2">
									<ul class="nav nav-pills nav-stacked" id="option">
										<?php $option_row = 0; ?>
										<?php foreach ($product_options as $product_option) { ?>
										<li><a href="#tab-option<?php echo $option_row; ?>" data-toggle="tab"><i class="fa fa-minus-circle"></i> <?php echo $product_option['name']; ?></a></li>
										<?php $option_row++; ?>
										<?php } ?>
										<li><input type="text" name="option" value="" placeholder="<?php echo $entry_option; ?>" id="input-option" class="form-control" /></li>
									</ul>
								</div>

								<div class="col-sm-10">
									<div class="tab-content">
										<?php $option_row = 0; ?>
										<?php $option_value_row = 0; ?>
										<?php foreach ($product_options as $product_option) { ?>
										<?php
										$product_option['raw_info']['sort_order'] = isset($product_option['raw_info']['sort_order']) ? $product_option['raw_info']['sort_order'] : '';
										$product_option['raw_info']['combination'] = isset($product_option['raw_info']['combination']) ? $product_option['raw_info']['combination'] : 1;
										?>
										<div class="tab-pane" id="tab-option<?php echo $option_row; ?>">
											<input type="hidden" name="product_option[<?php echo $option_row; ?>][product_option_id]" value="<?php echo $product_option['product_option_id']; ?>" />
											<input type="hidden" name="product_option[<?php echo $option_row; ?>][option_id]" value="<?php echo $product_option['option_id']; ?>" class="input-option-id" />
											<input type="hidden" name="product_option[<?php echo $option_row; ?>][sort_order]" value="<?php echo $product_option['raw_info']['sort_order']; ?>" class="input-option-sort" />
											<input type="hidden" name="product_option[<?php echo $option_row; ?>][type]" value="<?php echo $product_option['type']; ?>" class="input-option-type" />
											<input type="hidden" name="product_option[<?php echo $option_row; ?>][name]" value="<?php echo $product_option['name']; ?>" class="input-option-name" />

											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-required<?php echo $option_row; ?>"><?php echo $entry_required; ?></label>
												<div class="col-sm-10">
													<select name="product_option[<?php echo $option_row; ?>][required]" id="input-required<?php echo $option_row; ?>" class="form-control">
														<?php if ($product_option['required']) { ?>
														<option value="1" selected="selected"><?php echo $text_yes; ?></option>
														<option value="0"><?php echo $text_no; ?></option>
														<?php } else { ?>
														<option value="1"><?php echo $text_yes; ?></option>
														<option value="0" selected="selected"><?php echo $text_no; ?></option>
														<?php } ?>
													</select>
												</div>
											</div>

											<?php if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'image') { ?>
											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-combination<?php echo $option_row; ?>"><?php echo $entry_use_combination; ?></label>
												<div class="col-sm-10">
													<select name="product_option[<?php echo $option_row; ?>][combination]" id="input-combination<?php echo $option_row; ?>" class="form-control input-option-combination">
														<?php if ($product_option['raw_info']['combination']) { ?>
														<option value="1" selected="selected"><?php echo $text_yes; ?></option>
														<option value="0"><?php echo $text_no; ?></option>
														<?php } else { ?>
														<option value="1"><?php echo $text_yes; ?></option>
														<option value="0" selected="selected"><?php echo $text_no; ?></option>
														<?php } ?>
													</select>
												</div>
											</div>
											<?php } else { ?>
												<input type="hidden" name="product_option[<?php echo $option_row; ?>][combination]" value="0" />
											<?php } ?>

											<?php if ($product_option['type'] == 'text') { ?>
											<?php
											$tmp = $entry_option_value_default;
											if ($product_option['name'] == 'Largura e Altura (cm)') { $tmp = 'Largura Min / Largura Max / Altura Min / Altura Max'; }
											if ($product_option['name'] == 'Área total (m²)') { $tmp = 'Área total mínima'; }
											?>
											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-value<?php echo $option_row; ?>"><?php echo $tmp; ?></label>
												<div class="col-sm-10">
													<input type="text" name="product_option[<?php echo $option_row; ?>][value]" value="<?php echo $product_option['value']; ?>" placeholder="<?php echo $tmp; ?>" id="input-value<?php echo $option_row; ?>" class="form-control" />
												</div>
											</div>
											<?php } ?>
											<?php if ($product_option['type'] == 'textarea') { ?>
											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-value<?php echo $option_row; ?>"><?php echo $entry_option_value_default; ?></label>
												<div class="col-sm-10">
													<textarea name="product_option[<?php echo $option_row; ?>][value]" rows="5" placeholder="<?php echo $entry_option_value_default; ?>" id="input-value<?php echo $option_row; ?>" class="form-control"><?php echo $product_option['value']; ?></textarea>
												</div>
											</div>
											<?php } ?>
											<?php if ($product_option['type'] == 'file') { ?>
											<div class="form-group" style="display: none;">
												<label class="col-sm-2 control-label" for="input-value<?php echo $option_row; ?>"><?php echo $entry_option_value_default; ?></label>
												<div class="col-sm-10">
													<input type="text" name="product_option[<?php echo $option_row; ?>][value]" value="<?php echo $product_option['value']; ?>" placeholder="<?php echo $entry_option_value_default; ?>" id="input-value<?php echo $option_row; ?>" class="form-control" />
												</div>
											</div>
											<?php } ?>
											<?php if ($product_option['type'] == 'date') { ?>
											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-value<?php echo $option_row; ?>"><?php echo $entry_option_value_default; ?></label>
												<div class="col-sm-3">
													<div class="input-group date">
														<input type="text" name="product_option[<?php echo $option_row; ?>][value]" value="<?php echo $product_option['value']; ?>" placeholder="<?php echo $entry_option_value_default; ?>" data-date-format="YYYY-MM-DD" id="input-value<?php echo $option_row; ?>" class="form-control" />
														<span class="input-group-btn">
														<button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button>
														</span>
													</div>
												</div>
											</div>
											<?php } ?>
											<?php if ($product_option['type'] == 'time') { ?>
											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-value<?php echo $option_row; ?>"><?php echo $entry_option_value_default; ?></label>
												<div class="col-sm-10">
													<div class="input-group time">
														<input type="text" name="product_option[<?php echo $option_row; ?>][value]" value="<?php echo $product_option['value']; ?>" placeholder="<?php echo $entry_option_value_default; ?>" data-date-format="HH:mm" id="input-value<?php echo $option_row; ?>" class="form-control" />
														<span class="input-group-btn">
														<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
														</span>
													</div>
												</div>
											</div>
											<?php } ?>
											<?php if ($product_option['type'] == 'datetime') { ?>
											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-value<?php echo $option_row; ?>"><?php echo $entry_option_value_default; ?></label>
												<div class="col-sm-10">
													<div class="input-group datetime">
														<input type="text" name="product_option[<?php echo $option_row; ?>][value]" value="<?php echo $product_option['value']; ?>" placeholder="<?php echo $entry_option_value_default; ?>" data-date-format="YYYY-MM-DD HH:mm" id="input-value<?php echo $option_row; ?>" class="form-control" />
														<span class="input-group-btn">
														<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
														</span>
													</div>
												</div>
											</div>
											<?php } ?>
											<?php if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') { ?>
											<div class="table-responsive">
												<table id="option-value<?php echo $option_row; ?>" class="table table-striped table-bordered table-hover option-table">
													<thead>
														<tr>
															<td class="text-left" style="width: 20%;"><?php echo $entry_option_value; ?></td>
															<td class="text-right option-column-quantity" style="width: 10%;"><?php echo $entry_quantity; ?></td>
															<td class="text-left option-column-subtract" style="width: 10%;"><?php echo $entry_subtract; ?></td>
															<td class="text-right"><?php echo $entry_option_price; ?></td>
															<td class="text-right"><?php echo $entry_option_points; ?></td>
															<td class="text-right"><?php echo $entry_option_weight; ?></td>
															<td style="width: 5%;"></td>
														</tr>
													</thead>
													<tbody>
														<?php foreach ($product_option['product_option_value'] as $product_option_value) { ?>
														<tr id="option-value-row<?php echo $option_value_row; ?>">
															<td class="text-left">
																<select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][option_value_id]" class="form-control input-option-value-id">
																	<?php if (isset($option_values[$product_option['option_id']])) { ?>
																		<?php foreach ($option_values[$product_option['option_id']] as $option_value) { ?>
																			<?php if ($option_value['option_value_id'] == $product_option_value['option_value_id']) { ?>
																				<option value="<?php echo $option_value['option_value_id']; ?>" selected="selected" data-sort-order="<?php echo $option_value['sort_order']; ?>"><?php echo $option_value['name']; ?></option>
																			<?php } else { ?>
																				<option value="<?php echo $option_value['option_value_id']; ?>" data-sort-order="<?php echo $option_value['sort_order']; ?>"><?php echo $option_value['name']; ?></option>
																			<?php } ?>
																		<?php } ?>
																	<?php } ?>
																</select>
																<input type="hidden" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][product_option_value_id]" value="<?php echo $product_option_value['product_option_value_id']; ?>" />
															</td>
															<td class="text-right option-column-quantity"><input type="text" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][quantity]" value="<?php echo $product_option_value['quantity']; ?>" placeholder="<?php echo $entry_quantity; ?>" class="form-control input-option-quantity" /></td>
															<td class="text-left option-column-subtract">
																<select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][subtract]" class="form-control input-option-subtract">
																	<?php if ($product_option_value['subtract']) { ?>
																		<option value="1" selected="selected"><?php echo $text_yes; ?></option>
																		<option value="0"><?php echo $text_no; ?></option>
																	<?php } else { ?>
																		<option value="1"><?php echo $text_yes; ?></option>
																		<option value="0" selected="selected"><?php echo $text_no; ?></option>
																	<?php } ?>
																</select>
															</td>
															<td class="text-right">
																<select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][price_prefix]" class="form-control input-option-price-prefix">
																	<?php if ($product_option_value['price_prefix'] == '+') { ?>
																		<option value="+" selected="selected">+</option>
																	<?php } else { ?>
																		<option value="+">+</option>
																	<?php } ?>
																	<?php if ($product_option_value['price_prefix'] == '-') { ?>
																		<option value="-" selected="selected">-</option>
																	<?php } else { ?>
																		<option value="-">-</option>
																	<?php } ?>
																</select>
																<input type="text" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][price]" value="<?php echo $product_option_value['price']; ?>" placeholder="<?php echo $entry_price; ?>" class="form-control input-option-price" />
															</td>
															<td class="text-right">
																<select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][points_prefix]" class="form-control input-option-points-prefix">
																	<?php if ($product_option_value['points_prefix'] == '+') { ?>
																		<option value="+" selected="selected">+</option>
																	<?php } else { ?>
																		<option value="+">+</option>
																	<?php } ?>
																	<?php if ($product_option_value['points_prefix'] == '-') { ?>
																		<option value="-" selected="selected">-</option>
																	<?php } else { ?>
																		<option value="-">-</option>
																	<?php } ?>
																</select>
																<input type="text" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][points]" value="<?php echo $product_option_value['points']; ?>" placeholder="<?php echo $entry_points; ?>" class="form-control input-option-points" />
															</td>
															<td class="text-right">
																<select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][weight_prefix]" class="form-control input-option-weight-prefix">
																	<?php if ($product_option_value['weight_prefix'] == '+') { ?>
																		<option value="+" selected="selected">+</option>
																	<?php } else { ?>
																		<option value="+">+</option>
																	<?php } ?>
																	<?php if ($product_option_value['weight_prefix'] == '-') { ?>
																		<option value="-" selected="selected">-</option>
																	<?php } else { ?>
																		<option value="-">-</option>
																	<?php } ?>
																</select>
																<input type="text" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][weight]" value="<?php echo $product_option_value['weight']; ?>" placeholder="<?php echo $entry_weight; ?>" class="form-control input-option-weight" />
															</td>
															<td class="text-left"><button type="button" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger button-option-remove"><i class="fa fa-minus-circle"></i></button></td>
														</tr>
														<?php $option_value_row++; ?>
														<?php } ?>
													</tbody>
													<tfoot>
														<tr>
															<td colspan="20" class="text-left"><button type="button" onclick="addOptionValue('<?php echo $option_row; ?>');" data-toggle="tooltip" title="<?php echo $button_option_value_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
														</tr>
													</tfoot>
												</table>
											</div>
											<select id="option-values<?php echo $option_row; ?>" style="display: none;">
												<?php if (isset($option_values[$product_option['option_id']])) { ?>
													<?php foreach ($option_values[$product_option['option_id']] as $option_value) { ?>
													<option value="<?php echo $option_value['option_value_id']; ?>" data-sort-order="<?php echo $option_value['sort_order']; ?>"><?php echo $option_value['name']; ?></option>
													<?php } ?>
												<?php } ?>
											</select>
											<?php } ?>
										</div>
										<?php $option_row++; ?>
										<?php } ?>
									</div>
								</div>

							</div>
						</div><!-- #tab-option -->



						<div class="tab-pane" id="tab-combination">
							<div class="table-responsive">
								<table id="combination" class="table table-striped table-bordered table-hover">
									<thead>
										<tr>
											<td class="text-center" style="width: 5%;"><?php echo $entry_active; ?> <input id="combination-all-active" type="checkbox" value="1"></td>
											<td class="text-left" style="width: 30%;"><?php echo $entry_combination; ?> (<span id="combination-total">0</span>)</td>
											<td class="text-right" style="width: 10%;"><?php echo $entry_price_total; ?></td>
											<td class="text-right" style="width: 10%;"><?php echo $entry_points; ?></td>
											<td class="text-right" style="width: 10%;"><?php echo $entry_weight_total; ?></td>
											<td class="text-left" style="width: 20%;"><span data-toggle="tooltip" title="<?php echo $help_sku; ?>"><?php echo $entry_sku; ?></span></td>
											<td class="text-right" style="width: 10%;"><span data-toggle="tooltip" title="<?php echo $help_quantity_stock; ?>"><?php echo $entry_quantity_stock; ?></span></td>
											<td class="text-center" style="width: 5%;"><?php echo $entry_subtract; ?> <input id="combination-all-subtract" type="checkbox" value="1"></td>
										</tr>
									</thead>
									<tbody>
									</tbody>
								</table>
							</div>
						</div><!-- #tab-combination -->



						<div class="tab-pane" id="tab-attribute">
							<div class="table-responsive">
								<table id="attribute" class="table table-striped table-bordered table-hover">
									<thead>
										<tr>
											<td class="text-left" style="width: 35%;"><span data-toggle="tooltip" title="<?php echo $help_attribute; ?>"><?php echo $entry_attribute; ?></span></td>
											<td class="text-left"><?php echo $entry_text; ?></td>
											<td style="width: 5%;"></td>
										</tr>
									</thead>
									<tbody>
										<?php $attribute_row = 0; ?>
										<?php foreach ($product_attributes as $product_attribute) { ?>
										<tr id="attribute-row<?php echo $attribute_row; ?>">
											<td class="text-left">
												<input type="text" name="product_attribute[<?php echo $attribute_row; ?>][name]" value="<?php echo $product_attribute['name']; ?>" placeholder="<?php echo $entry_attribute; ?>" class="form-control attribute-name" />
												<input type="hidden" name="product_attribute[<?php echo $attribute_row; ?>][attribute_id]" value="<?php echo $product_attribute['attribute_id']; ?>" />
											</td>
											<td class="text-left">
												<?php foreach ($languages as $language) { ?>
												<div class="input-group">
													<span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>
													<textarea name="product_attribute[<?php echo $attribute_row; ?>][product_attribute_description][<?php echo $language['language_id']; ?>][text]" rows="5" placeholder="<?php echo $entry_text; ?>" class="form-control attribute-description"><?php echo isset($product_attribute['product_attribute_description'][$language['language_id']]) ? $product_attribute['product_attribute_description'][$language['language_id']]['text'] : ''; ?></textarea>
												</div>
												<?php } ?>
											</td>
											<td class="text-left"><button type="button" onclick="$('#attribute-row<?php echo $attribute_row; ?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
										</tr>
										<?php $attribute_row++; ?>
										<?php } ?>
									</tbody>
									<tfoot>
										<tr>
											<td colspan="20" class="text-left"><button type="button" onclick="addAttribute();" data-toggle="tooltip" title="<?php echo $button_attribute_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
										</tr>
									</tfoot>
								</table>
							</div>
						</div><!-- #tab-attribute -->



						<div class="tab-pane" id="tab-recurring">
							<div class="table-responsive">
								<table class="table table-striped table-bordered table-hover">
									<thead>
										<tr>
											<td class="text-left"><?php echo $entry_recurring; ?></td>
											<td class="text-left" style="width: 30%;"><?php echo $entry_customer_group; ?></td>
											<td style="width: 5%;"></td>
										</tr>
									</thead>
									<tbody>
										<?php $recurring_row = 0; ?>
										<?php foreach ($product_recurrings as $product_recurring) { ?>

										<tr id="recurring-row<?php echo $recurring_row; ?>">
											<td class="text-left">
												<select name="product_recurring[<?php echo $recurring_row; ?>][recurring_id]" class="form-control recurring-id">
													<?php foreach ($recurrings as $recurring) { ?>
													<?php if ($recurring['recurring_id'] == $product_recurring['recurring_id']) { ?>
													<option value="<?php echo $recurring['recurring_id']; ?>" selected="selected"><?php echo $recurring['name']; ?></option>
													<?php } else { ?>
													<option value="<?php echo $recurring['recurring_id']; ?>"><?php echo $recurring['name']; ?></option>
													<?php } ?>
													<?php } ?>
												</select>
											</td>
											<td class="text-left">
												<select name="product_recurring[<?php echo $recurring_row; ?>][customer_group_id]" class="form-control recurring-group">
													<?php foreach ($customer_groups as $customer_group) { ?>
													<?php if ($customer_group['customer_group_id'] == $product_recurring['customer_group_id']) { ?>
													<option value="<?php echo $customer_group['customer_group_id']; ?>" selected="selected"><?php echo $customer_group['name']; ?></option>
													<?php } else { ?>
													<option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>
													<?php } ?>
													<?php } ?>
												</select>
											</td>
											<td class="text-left"><button type="button" onclick="$('#recurring-row<?php echo $recurring_row; ?>').remove()" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
										</tr>
										<?php $recurring_row++; ?>
										<?php } ?>
									</tbody>
									<tfoot>
										<tr>
											<td colspan="20" class="text-left"><button type="button" onclick="addRecurring()" data-toggle="tooltip" title="<?php echo $button_recurring_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
										</tr>
									</tfoot>
								</table>
							</div>
						</div><!-- #tab-recurring -->



						<div class="tab-pane" id="tab-discount">
							<div class="table-responsive">
								<table id="discount" class="table table-striped table-bordered table-hover">
									<thead>
										<tr>
											<td class="text-left"><?php echo $entry_customer_group; ?></td>
											<td class="text-right" style="width: 10%;"><?php echo $entry_discount_quantity; ?></td>
											<td class="text-right" style="width: 10%;"><?php echo $entry_priority; ?></td>
											<td class="text-right" style="width: 15%;"><?php echo $entry_discount_price; ?></td>
											<td class="text-left" style="width: 15%;"><?php echo $entry_date_start; ?></td>
											<td class="text-left" style="width: 15%;"><?php echo $entry_date_end; ?></td>
											<td style="width: 5%;"></td>
										</tr>
									</thead>
									<tbody>
										<?php $discount_row = 0; ?>
										<?php foreach ($product_discounts as $product_discount) { ?>
										<tr id="discount-row<?php echo $discount_row; ?>">
											<td class="text-left">
												<select name="product_discount[<?php echo $discount_row; ?>][customer_group_id]" class="form-control discount-group">
													<?php foreach ($customer_groups as $customer_group) { ?>
													<?php if ($customer_group['customer_group_id'] == $product_discount['customer_group_id']) { ?>
													<option value="<?php echo $customer_group['customer_group_id']; ?>" selected="selected"><?php echo $customer_group['name']; ?></option>
													<?php } else { ?>
													<option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>
													<?php } ?>
													<?php } ?>
												</select>
											</td>
											<td class="text-right"><input type="text" name="product_discount[<?php echo $discount_row; ?>][quantity]" value="<?php echo $product_discount['quantity']; ?>" placeholder="<?php echo $entry_quantity; ?>" class="form-control discount-quantity" /></td>
											<td class="text-right"><input type="text" name="product_discount[<?php echo $discount_row; ?>][priority]" value="<?php echo $product_discount['priority']; ?>" placeholder="<?php echo $entry_priority; ?>" class="form-control discount-priority" /></td>
											<td class="text-right"><input type="text" name="product_discount[<?php echo $discount_row; ?>][price]" value="<?php echo $product_discount['price']; ?>" placeholder="<?php echo $entry_price; ?>" class="form-control discount-price" /></td>
											<td class="text-left">
												<div class="input-group date">
													<input type="text" name="product_discount[<?php echo $discount_row; ?>][date_start]" value="<?php echo $product_discount['date_start']; ?>" placeholder="<?php echo $entry_date_start; ?>" data-date-format="YYYY-MM-DD" class="form-control" />
													<span class="input-group-btn">
													<button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button>
													</span>
												</div>
											</td>
											<td class="text-left">
												<div class="input-group date">
													<input type="text" name="product_discount[<?php echo $discount_row; ?>][date_end]" value="<?php echo $product_discount['date_end']; ?>" placeholder="<?php echo $entry_date_end; ?>" data-date-format="YYYY-MM-DD" class="form-control" />
													<span class="input-group-btn">
													<button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button>
													</span>
												</div>
											</td>
											<td class="text-left"><button type="button" onclick="$('#discount-row<?php echo $discount_row; ?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
										</tr>
										<?php $discount_row++; ?>
										<?php } ?>
									</tbody>
									<tfoot>
										<tr>
											<td colspan="20" class="text-left"><button type="button" onclick="addDiscount();" data-toggle="tooltip" title="<?php echo $button_discount_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
										</tr>
									</tfoot>
								</table>
							</div>
						</div><!-- #tab-discount -->



						<div class="tab-pane" id="tab-special">
							<div class="table-responsive">
								<table id="special" class="table table-striped table-bordered table-hover">
									<thead>
										<tr>
											<td class="text-left"><?php echo $entry_customer_group; ?></td>
											<td class="text-right" style="width: 10%;"><?php echo $entry_priority; ?></td>
											<td class="text-right" style="width: 15%;"><?php echo $entry_special_price; ?></td>
											<td class="text-left" style="width: 15%;"><?php echo $entry_date_start; ?></td>
											<td class="text-left" style="width: 15%;"><?php echo $entry_date_end; ?></td>
											<td style="width: 5%;"></td>
										</tr>
									</thead>
									<tbody>
										<?php $special_row = 0; ?>
										<?php foreach ($product_specials as $product_special) { ?>
										<tr id="special-row<?php echo $special_row; ?>">
											<td class="text-left">
												<select name="product_special[<?php echo $special_row; ?>][customer_group_id]" class="form-control special-group">
													<?php foreach ($customer_groups as $customer_group) { ?>
													<?php if ($customer_group['customer_group_id'] == $product_special['customer_group_id']) { ?>
													<option value="<?php echo $customer_group['customer_group_id']; ?>" selected="selected"><?php echo $customer_group['name']; ?></option>
													<?php } else { ?>
													<option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>
													<?php } ?>
													<?php } ?>
												</select></td>
											<td class="text-right"><input type="text" name="product_special[<?php echo $special_row; ?>][priority]" value="<?php echo $product_special['priority']; ?>" placeholder="<?php echo $entry_quantity; ?>" class="form-control special-priority" /></td>
											<td class="text-right"><input type="text" name="product_special[<?php echo $special_row; ?>][price]" value="<?php echo $product_special['price']; ?>" placeholder="<?php echo $entry_price; ?>" class="form-control special-price" /></td>
											<td class="text-left">
												<div class="input-group date">
													<input type="text" name="product_special[<?php echo $special_row; ?>][date_start]" value="<?php echo $product_special['date_start']; ?>" placeholder="<?php echo $entry_date_start; ?>" data-date-format="YYYY-MM-DD" class="form-control" />
													<span class="input-group-btn">
													<button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button>
													</span>
												</div>
											</td>
											<td class="text-left">
												<div class="input-group date">
													<input type="text" name="product_special[<?php echo $special_row; ?>][date_end]" value="<?php echo $product_special['date_end']; ?>" placeholder="<?php echo $entry_date_end; ?>" data-date-format="YYYY-MM-DD" class="form-control" />
													<span class="input-group-btn">
													<button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button>
													</span>
												</div>
											</td>
											<td class="text-left"><button type="button" onclick="$('#special-row<?php echo $special_row; ?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
										</tr>
										<?php $special_row++; ?>
										<?php } ?>
									</tbody>
									<tfoot>
										<tr>
											<td colspan="20" class="text-left"><button type="button" onclick="addSpecial();" data-toggle="tooltip" title="<?php echo $button_special_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
										</tr>
									</tfoot>
								</table>
							</div>
						</div><!-- #tab-special -->



						<div class="tab-pane" id="tab-image">
							<div class="table-responsive">
								<table id="images" class="table table-striped table-bordered table-hover">
									<thead>
										<tr>
											<td class="text-left"><?php echo $entry_image; ?></td>
											<td class="text-right"><?php echo $entry_sort_order; ?></td>
											<td style="width: 5%;"></td>
										</tr>
									</thead>
									<tbody>
										<?php $image_row = 0; ?>
										<?php foreach ($product_images as $product_image) { ?>
										<tr id="image-row<?php echo $image_row; ?>">
											<td class="text-left"><a href="" id="thumb-image<?php echo $image_row; ?>" data-toggle="image" class="img-thumbnail"><img src="<?php echo $product_image['thumb']; ?>" alt="" title="" data-placeholder="<?php echo $placeholder; ?>" /></a><input type="hidden" name="product_image[<?php echo $image_row; ?>][image]" value="<?php echo $product_image['image']; ?>" id="input-image<?php echo $image_row; ?>" /></td>
											<td class="text-right"><input type="text" name="product_image[<?php echo $image_row; ?>][sort_order]" value="<?php echo $product_image['sort_order']; ?>" placeholder="<?php echo $entry_sort_order; ?>" class="form-control" /></td>
											<td class="text-left"><button type="button" onclick="$('#image-row<?php echo $image_row; ?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
										</tr>
										<?php $image_row++; ?>
										<?php } ?>
									</tbody>
									<tfoot>
										<tr>
											<td colspan="20" class="text-left"><button type="button" onclick="addImage();" data-toggle="tooltip" title="<?php echo $button_image_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
										</tr>
									</tfoot>
								</table>
							</div>
						</div><!-- #tab-image -->



						<div class="tab-pane" id="tab-reward">
							<div class="form-group">
								<label class="col-lg-2 control-label" for="input-points"><span data-toggle="tooltip" title="<?php echo $help_points; ?>"><?php echo $entry_points; ?></span></label>
								<div class="col-lg-10">
									<input type="text" name="points" value="<?php echo $points; ?>" placeholder="<?php echo $entry_points; ?>" id="input-points" class="form-control" />
								</div>
							</div>
							<div class="table-responsive">
								<table class="table table-bordered table-hover">
									<thead>
										<tr>
											<td class="text-left" style="width: 50%;"><?php echo $entry_customer_group; ?></td>
											<td class="text-right" style="width: 50%;"><?php echo $entry_reward; ?></td>
										</tr>
									</thead>
									<tbody>
										<?php foreach ($customer_groups as $customer_group) { ?>
										<tr>
											<td class="text-left"><?php echo $customer_group['name']; ?></td>
											<td class="text-right"><input type="text" name="product_reward[<?php echo $customer_group['customer_group_id']; ?>][points]" value="<?php echo isset($product_reward[$customer_group['customer_group_id']]) ? $product_reward[$customer_group['customer_group_id']]['points'] : ''; ?>" class="form-control" /></td>
										</tr>
										<?php } ?>
									</tbody>
								</table>
							</div>
						</div><!-- #tab-reward -->



						<div class="tab-pane" id="tab-design">
							<div class="table-responsive">
								<table class="table table-bordered table-hover">
									<thead>
										<tr>
											<td class="text-left"><?php echo $entry_store; ?></td>
											<td class="text-left"><?php echo $entry_layout; ?></td>
										</tr>
									</thead>
									<tbody>
										<tr>
											<td class="text-left"><?php echo $text_default; ?></td>
											<td class="text-left"><select name="product_layout[0]" class="form-control">
													<option value=""></option>
													<?php foreach ($layouts as $layout) { ?>
													<?php if (isset($product_layout[0]) && $product_layout[0] == $layout['layout_id']) { ?>
													<option value="<?php echo $layout['layout_id']; ?>" selected="selected"><?php echo $layout['name']; ?></option>
													<?php } else { ?>
													<option value="<?php echo $layout['layout_id']; ?>"><?php echo $layout['name']; ?></option>
													<?php } ?>
													<?php } ?>
												</select></td>
										</tr>
										<?php foreach ($stores as $store) { ?>
										<tr>
											<td class="text-left"><?php echo $store['name']; ?></td>
											<td class="text-left"><select name="product_layout[<?php echo $store['store_id']; ?>]" class="form-control">
													<option value=""></option>
													<?php foreach ($layouts as $layout) { ?>
													<?php if (isset($product_layout[$store['store_id']]) && $product_layout[$store['store_id']] == $layout['layout_id']) { ?>
													<option value="<?php echo $layout['layout_id']; ?>" selected="selected"><?php echo $layout['name']; ?></option>
													<?php } else { ?>
													<option value="<?php echo $layout['layout_id']; ?>"><?php echo $layout['name']; ?></option>
													<?php } ?>
													<?php } ?>
												</select></td>
										</tr>
										<?php } ?>
									</tbody>
								</table>
							</div>
						</div><!-- #tab-design -->



					</div><!-- .tab-content -->



				</form>

			</div><!-- .panel-body -->
		</div><!-- .panel -->

	</div><!-- .container-fluid -->
</div><!-- #content -->



<style>
.input-group.date {
	min-width: 130px;
}
.attribute-name,
.attribute-description,
.input-option-value-id,
.recurring-id,
.recurring-group,
.discount-group,
.special-group {
	min-width: 100px;
}
.input-option-quantity,
.discount-quantity,
.discount-priority,
.special-priority {
	min-width: 60px;
}
.input-option-subtract,
.input-option-price,
.input-option-points,
.input-option-weight,
.discount-price,
.special-price {
	min-width: 80px;
}

.has-combination .stock-quantity,
.has-combination .stock-subtract,
.has-combination .stock-sku,
.has-combination .option-table .option-column-quantity,
.has-combination .option-table .option-column-subtract {
	display: none;
}

@media (max-width: 767px) {
	#tab-option .tab-content {
		margin-top: 20px;
	}

	.table-responsive > .table > thead > tr > th,
	.table-responsive > .table > tbody > tr > th,
	.table-responsive > .table > tfoot > tr > th,
	.table-responsive > .table > thead > tr > td,
	.table-responsive > .table > tbody > tr > td,
	.table-responsive > .table > tfoot > tr > td {
		white-space: normal;
	}
}
</style>



<script type="text/javascript"><!--
<?php foreach ($languages as $language) { ?>
$('#input-description<?php echo $language['language_id']; ?>').summernote({height: 300});
<?php } ?>
//--></script>



<script type="text/javascript"><!--
// Manufacturer
$('input[name=\'manufacturer\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/manufacturer/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
			dataType: 'json',
			success: function(json) {
				json.unshift({
					manufacturer_id: 0,
					name: '<?php echo $text_none; ?>'
				});

				response($.map(json, function(item) {
					return {
						label: item['name'],
						value: item['manufacturer_id']
					}
				}));
			}
		});
	},
	'select': function(item) {
		$('input[name=\'manufacturer\']').val(item['label']);
		$('input[name=\'manufacturer_id\']').val(item['value']);
	}
});

// Category
$('input[name=\'category\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/category/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						label: item['name'],
						value: item['category_id']
					}
				}));
			}
		});
	},
	'select': function(item) {
		$('input[name=\'category\']').val('');

		$('#product-category' + item['value']).remove();

		$('#product-category').append('<div id="product-category' + item['value'] + '"><i class="fa fa-minus-circle"></i> ' + item['label'] + '<input type="hidden" name="product_category[]" value="' + item['value'] + '" /></div>');
	}
});

$('#product-category').delegate('.fa-minus-circle', 'click', function() {
	$(this).parent().remove();
});

// Filter
$('input[name=\'filter\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/filter/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						label: item['name'],
						value: item['filter_id']
					}
				}));
			}
		});
	},
	'select': function(item) {
		$('input[name=\'filter\']').val('');

		$('#product-filter' + item['value']).remove();

		$('#product-filter').append('<div id="product-filter' + item['value'] + '"><i class="fa fa-minus-circle"></i> ' + item['label'] + '<input type="hidden" name="product_filter[]" value="' + item['value'] + '" /></div>');
	}
});

$('#product-filter').delegate('.fa-minus-circle', 'click', function() {
	$(this).parent().remove();
});

// Downloads
$('input[name=\'download\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/download/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						label: item['name'],
						value: item['download_id']
					}
				}));
			}
		});
	},
	'select': function(item) {
		$('input[name=\'download\']').val('');

		$('#product-download' + item['value']).remove();

		$('#product-download').append('<div id="product-download' + item['value'] + '"><i class="fa fa-minus-circle"></i> ' + item['label'] + '<input type="hidden" name="product_download[]" value="' + item['value'] + '" /></div>');
	}
});

$('#product-download').delegate('.fa-minus-circle', 'click', function() {
	$(this).parent().remove();
});

// Related
$('input[name=\'related\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/product/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						label: item['name'],
						value: item['product_id']
					}
				}));
			}
		});
	},
	'select': function(item) {
		$('input[name=\'related\']').val('');

		$('#product-related' + item['value']).remove();

		$('#product-related').append('<div id="product-related' + item['value'] + '"><i class="fa fa-minus-circle"></i> ' + item['label'] + '<input type="hidden" name="product_related[]" value="' + item['value'] + '" /></div>');
	}
});

$('#product-related').delegate('.fa-minus-circle', 'click', function() {
	$(this).parent().remove();
});
//--></script>



<script type="text/javascript"><!--
var attribute_row = <?php echo $attribute_row; ?>;

function addAttribute() {
	html  = '<tr id="attribute-row' + attribute_row + '">';
	html += '  <td class="text-left">';
	html += '    <input type="text" name="product_attribute[' + attribute_row + '][name]" value="" placeholder="<?php echo $entry_attribute; ?>" class="form-control attribute-name" />';
	html += '    <input type="hidden" name="product_attribute[' + attribute_row + '][attribute_id]" value="" />';
	html += '  </td>';
	html += '  <td class="text-left">';
	<?php foreach ($languages as $language) { ?>
	html += '    <div class="input-group">';
	html += '      <span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>';
	html += '      <textarea name="product_attribute[' + attribute_row + '][product_attribute_description][<?php echo $language['language_id']; ?>][text]" rows="5" placeholder="<?php echo $entry_text; ?>" class="form-control attribute-description"></textarea>';
	html += '    </div>';
	<?php } ?>
	html += '  </td>';
	html += '  <td class="text-left"><button type="button" onclick="$(\'#attribute-row' + attribute_row + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
	html += '</tr>';

	$('#attribute tbody').append(html);

	attributeautocomplete(attribute_row);

	attribute_row++;
}

function attributeautocomplete(attribute_row) {
	$('input[name=\'product_attribute[' + attribute_row + '][name]\']').autocomplete({
		'source': function(request, response) {
			$.ajax({
				url: 'index.php?route=catalog/attribute/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
				dataType: 'json',
				success: function(json) {
					response($.map(json, function(item) {
						return {
							category: item.attribute_group,
							label: item.name,
							value: item.attribute_id
						}
					}));
				}
			});
		},
		'select': function(item) {
			$('input[name=\'product_attribute[' + attribute_row + '][name]\']').val(item['label']);
			$('input[name=\'product_attribute[' + attribute_row + '][attribute_id]\']').val(item['value']);
		}
	});
}

$('#attribute tbody tr').each(function(index, element) {
	attributeautocomplete(index);
});
//--></script>



<script type="text/javascript"><!--
var option_row = <?php echo $option_row; ?>;

$('input[name=\'option\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/option/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						category: item['category'],
						label: item['name'],
						value: item['option_id'],
						sort_order: item['raw_info']['sort_order'],
						type: item['type'],
						option_value: item['option_value']
					}
				}));
			}
		});
	},
	'select': function(item) {
		html  = '<div class="tab-pane" id="tab-option' + option_row + '">';
		html += '	<input type="hidden" name="product_option[' + option_row + '][product_option_id]" value="" />';
		html += '	<input type="hidden" name="product_option[' + option_row + '][option_id]" value="' + item['value'] + '" class="input-option-id" />';
		html += '	<input type="hidden" name="product_option[' + option_row + '][sort_order]" value="' + item['sort_order'] + '" class="input-option-sort" />';
		html += '	<input type="hidden" name="product_option[' + option_row + '][type]" value="' + item['type'] + '" class="input-option-type" />';
		html += '	<input type="hidden" name="product_option[' + option_row + '][name]" value="' + item['label'] + '" class="input-option-name" />';

		html += '	<div class="form-group">';
		html += '	  <label class="col-sm-2 control-label" for="input-required' + option_row + '"><?php echo $entry_required; ?></label>';
		html += '	  <div class="col-sm-10"><select name="product_option[' + option_row + '][required]" id="input-required' + option_row + '" class="form-control">';
		html += '	      <option value="1"><?php echo $text_yes; ?></option>';
		html += '	      <option value="0"><?php echo $text_no; ?></option>';
		html += '	  </select></div>';
		html += '	</div>';

		if (item['type'] == 'select' || item['type'] == 'radio' || item['type'] == 'image') {
			html += '	<div class="form-group">';
			html += '	  <label class="col-sm-2 control-label" for="input-combination' + option_row + '"><?php echo $entry_use_combination; ?></label>';
			html += '	  <div class="col-sm-10"><select name="product_option[' + option_row + '][combination]" id="input-combination' + option_row + '" class="form-control input-option-combination">';
			html += '	      <option value="1"><?php echo $text_yes; ?></option>';
			html += '	      <option value="0"><?php echo $text_no; ?></option>';
			html += '	  </select></div>';
			html += '	</div>';
		} else {
			html += '<input type="hidden" name="product_option[' + option_row + '][combination]" value="0" />';
		}

		if (item['type'] == 'text') {
			var tmp = '<?php echo $entry_option_value_default; ?>';
			if (item['label'] == 'Largura e Altura (cm)') { tmp = 'Largura Min / Largura Max / Altura Min / Altura Max'; }
			if (item['label'] == 'Área total (m²)') { tmp = 'Área total mínima'; }

			html += '	<div class="form-group">';
			html += '	  <label class="col-sm-2 control-label" for="input-value' + option_row + '">' + tmp + '</label>';
			html += '	  <div class="col-sm-10"><input type="text" name="product_option[' + option_row + '][value]" value="" placeholder="' + tmp + '" id="input-value' + option_row + '" class="form-control" /></div>';
			html += '	</div>';
		}

		if (item['type'] == 'textarea') {
			html += '	<div class="form-group">';
			html += '	  <label class="col-sm-2 control-label" for="input-value' + option_row + '"><?php echo $entry_option_value_default; ?></label>';
			html += '	  <div class="col-sm-10"><textarea name="product_option[' + option_row + '][value]" rows="5" placeholder="<?php echo $entry_option_value_default; ?>" id="input-value' + option_row + '" class="form-control"></textarea></div>';
			html += '	</div>';
		}

		if (item['type'] == 'file') {
			html += '	<div class="form-group" style="display: none;">';
			html += '	  <label class="col-sm-2 control-label" for="input-value' + option_row + '"><?php echo $entry_option_value_default; ?></label>';
			html += '	  <div class="col-sm-10"><input type="text" name="product_option[' + option_row + '][value]" value="" placeholder="<?php echo $entry_option_value_default; ?>" id="input-value' + option_row + '" class="form-control" /></div>';
			html += '	</div>';
		}

		if (item['type'] == 'date') {
			html += '	<div class="form-group">';
			html += '	  <label class="col-sm-2 control-label" for="input-value' + option_row + '"><?php echo $entry_option_value_default; ?></label>';
			html += '	  <div class="col-sm-10"><div class="input-group date"><input type="text" name="product_option[' + option_row + '][value]" value="" placeholder="<?php echo $entry_option_value_default; ?>" data-date-format="YYYY-MM-DD" id="input-value' + option_row + '" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div></div>';
			html += '	</div>';
		}

		if (item['type'] == 'time') {
			html += '	<div class="form-group">';
			html += '	  <label class="col-sm-2 control-label" for="input-value' + option_row + '"><?php echo $entry_option_value_default; ?></label>';
			html += '	  <div class="col-sm-10"><div class="input-group time"><input type="text" name="product_option[' + option_row + '][value]" value="" placeholder="<?php echo $entry_option_value_default; ?>" data-date-format="HH:mm" id="input-value' + option_row + '" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div></div>';
			html += '	</div>';
		}

		if (item['type'] == 'datetime') {
			html += '	<div class="form-group">';
			html += '	  <label class="col-sm-2 control-label" for="input-value' + option_row + '"><?php echo $entry_option_value_default; ?></label>';
			html += '	  <div class="col-sm-10"><div class="input-group datetime"><input type="text" name="product_option[' + option_row + '][value]" value="" placeholder="<?php echo $entry_option_value_default; ?>" data-date-format="YYYY-MM-DD HH:mm" id="input-value' + option_row + '" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div></div>';
			html += '	</div>';
		}

		if (item['type'] == 'select' || item['type'] == 'radio' || item['type'] == 'checkbox' || item['type'] == 'image') {
			html += '<div class="table-responsive">';
			html += '  <table id="option-value' + option_row + '" class="table table-striped table-bordered table-hover option-table">';
			html += '  	 <thead>';
			html += '      <tr>';
			html += '        <td class="text-left" style="width: 20%;"><?php echo $entry_option_value; ?></td>';
			html += '        <td class="text-right option-column-quantity" style="width: 10%;"><?php echo $entry_quantity; ?></td>';
			html += '        <td class="text-left option-column-subtract" style="width: 10%;"><?php echo $entry_subtract; ?></td>';
			html += '        <td class="text-right"><?php echo $entry_price; ?></td>';
			html += '        <td class="text-right"><?php echo $entry_option_points; ?></td>';
			html += '        <td class="text-right"><?php echo $entry_weight; ?></td>';
			html += '        <td style="width: 5%;"></td>';
			html += '      </tr>';
			html += '  	 </thead>';
			html += '  	 <tbody>';
			html += '    </tbody>';
			html += '    <tfoot>';
			html += '      <tr>';
			html += '        <td colspan="7" class="text-left"><button type="button" onclick="addOptionValue(' + option_row + ');" data-toggle="tooltip" title="<?php echo $button_option_value_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>';
			html += '      </tr>';
			html += '    </tfoot>';
			html += '  </table>';
			html += '</div>';

			html += '  <select id="option-values' + option_row + '" style="display: none;">';
			for (i = 0; i < item['option_value'].length; i++) {
				html += '  <option value="' + item['option_value'][i]['option_value_id'] + '" data-sort-order="' + item['option_value'][i]['raw_info']['sort_order'] + '">' + item['option_value'][i]['name'] + '</option>';
			}
			html += '  </select>';
		}

		html += '</div>';

		$('#tab-option .tab-content').append(html);

		$('#option > li:last-child').before('<li><a href="#tab-option' + option_row + '" data-toggle="tab"><i class="fa fa-minus-circle"></i> ' + item['label'] + '</li>');

		$('#option a[href=\'#tab-option' + option_row + '\']').tab('show');

		$('#tab-option' + option_row).find('.input-option-combination').trigger('change');

		option_row++;
	}
});
//--></script>

<script type="text/javascript"><!--
var option_value_row = <?php echo $option_value_row; ?>;

function addOptionValue(option_row) {
	html  = '<tr id="option-value-row' + option_value_row + '">';
	html += '  <td class="text-left">';
	html += '    <select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][option_value_id]" class="form-control input-option-value-id">';
	html +=        $('#option-values' + option_row).html();
	html += '    </select>';
	html += '    <input type="hidden" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][product_option_value_id]" value="" />';
	html += '  </td>';
	html += '  <td class="text-right option-column-quantity"><input type="text" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][quantity]" value="" placeholder="<?php echo $entry_quantity; ?>" class="form-control input-option-quantity" /></td>';
	html += '  <td class="text-left option-column-subtract">';
	html += '    <select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][subtract]" class="form-control input-option-subtract">';
	html += '      <option value="1"><?php echo $text_yes; ?></option>';
	html += '      <option value="0"><?php echo $text_no; ?></option>';
	html += '    </select>';
	html += '  </td>';
	html += '  <td class="text-right">';
	html += '    <select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][price_prefix]" class="form-control input-option-price-prefix">';
	html += '      <option value="+">+</option>';
	html += '      <option value="-">-</option>';
	html += '    </select>';
	html += '    <input type="text" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][price]" value="" placeholder="<?php echo $entry_price; ?>" class="form-control input-option-price" />';
	html += '  </td>';
	html += '  <td class="text-right">';
	html += '    <select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][points_prefix]" class="form-control input-option-points-prefix">';
	html += '      <option value="+">+</option>';
	html += '      <option value="-">-</option>';
	html += '    </select>';
	html += '    <input type="text" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][points]" value="" placeholder="<?php echo $entry_points; ?>" class="form-control input-option-points" />';
	html += '  </td>';
	html += '  <td class="text-right">';
	html += '    <select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][weight_prefix]" class="form-control input-option-weight-prefix">';
	html += '      <option value="+">+</option>';
	html += '      <option value="-">-</option>';
	html += '    </select>';
	html += '    <input type="text" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][weight]" value="" placeholder="<?php echo $entry_weight; ?>" class="form-control input-option-weight" />';
	html += '  </td>';
	html += '  <td class="text-left"><button type="button" data-toggle="tooltip" rel="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger button-option-remove"><i class="fa fa-minus-circle"></i></button></td>';
	html += '</tr>';

	$('#option-value' + option_row).find('tbody').append(html);
	$('[rel=tooltip]').tooltip();

	$('#option-value-row' + option_value_row).find('.input-option-value-id').trigger('change');

	option_value_row++;
}
//--></script>



<script type="text/javascript"><!--
var discount_row = <?php echo $discount_row; ?>;

function addDiscount() {
	html  = '<tr id="discount-row' + discount_row + '">';
	html += '  <td class="text-left">';
	html += '    <select name="product_discount[' + discount_row + '][customer_group_id]" class="form-control discount-group">';
	<?php foreach ($customer_groups as $customer_group) { ?>
	html += '      <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo addslashes($customer_group['name']); ?></option>';
	<?php } ?>
	html += '    </select>';
	html += '  </td>';
	html += '  <td class="text-right"><input type="text" name="product_discount[' + discount_row + '][quantity]" value="" placeholder="<?php echo $entry_quantity; ?>" class="form-control discount-quantity" /></td>';
	html += '  <td class="text-right"><input type="text" name="product_discount[' + discount_row + '][priority]" value="" placeholder="<?php echo $entry_priority; ?>" class="form-control discount-priority" /></td>';
	html += '  <td class="text-right"><input type="text" name="product_discount[' + discount_row + '][price]" value="" placeholder="<?php echo $entry_price; ?>" class="form-control discount-price" /></td>';
	html += '  <td class="text-left"><div class="input-group date"><input type="text" name="product_discount[' + discount_row + '][date_start]" value="" placeholder="<?php echo $entry_date_start; ?>" data-date-format="YYYY-MM-DD" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div></td>';
	html += '  <td class="text-left"><div class="input-group date"><input type="text" name="product_discount[' + discount_row + '][date_end]" value="" placeholder="<?php echo $entry_date_end; ?>" data-date-format="YYYY-MM-DD" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div></td>';
	html += '  <td class="text-left"><button type="button" onclick="$(\'#discount-row' + discount_row + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
	html += '</tr>';

	$('#discount tbody').append(html);

	discount_row++;
}
//--></script>



<script type="text/javascript"><!--
var special_row = <?php echo $special_row; ?>;

function addSpecial() {
	html  = '<tr id="special-row' + special_row + '">';
	html += '  <td class="text-left">';
	html += '    <select name="product_special[' + special_row + '][customer_group_id]" class="form-control special-group">';
	<?php foreach ($customer_groups as $customer_group) { ?>
	html += '      <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo addslashes($customer_group['name']); ?></option>';
	<?php } ?>
	html += '    </select>';
	html += '  </td>';
	html += '  <td class="text-right"><input type="text" name="product_special[' + special_row + '][priority]" value="" placeholder="<?php echo $entry_priority; ?>" class="form-control special-priority" /></td>';
	html += '  <td class="text-right"><input type="text" name="product_special[' + special_row + '][price]" value="" placeholder="<?php echo $entry_price; ?>" class="form-control special-price" /></td>';
	html += '  <td class="text-left"><div class="input-group date"><input type="text" name="product_special[' + special_row + '][date_start]" value="" placeholder="<?php echo $entry_date_start; ?>" data-date-format="YYYY-MM-DD" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div></td>';
	html += '  <td class="text-left"><div class="input-group date"><input type="text" name="product_special[' + special_row + '][date_end]" value="" placeholder="<?php echo $entry_date_end; ?>" data-date-format="YYYY-MM-DD" class="form-control" /><span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span></div></td>';
	html += '  <td class="text-left"><button type="button" onclick="$(\'#special-row' + special_row + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
	html += '</tr>';

	$('#special tbody').append(html);

	special_row++;
}
//--></script>



<script type="text/javascript"><!--
var image_row = <?php echo $image_row; ?>;

function addImage() {
	html  = '<tr id="image-row' + image_row + '">';
	html += '  <td class="text-left"><a href="" id="thumb-image' + image_row + '"data-toggle="image" class="img-thumbnail"><img src="<?php echo $placeholder; ?>" alt="" title="" data-placeholder="<?php echo $placeholder; ?>" /><input type="hidden" name="product_image[' + image_row + '][image]" value="" id="input-image' + image_row + '" /></td>';
	html += '  <td class="text-right"><input type="text" name="product_image[' + image_row + '][sort_order]" value="" placeholder="<?php echo $entry_sort_order; ?>" class="form-control" /></td>';
	html += '  <td class="text-left"><button type="button" onclick="$(\'#image-row' + image_row  + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
	html += '</tr>';

	$('#images tbody').append(html);

	image_row++;
}
//--></script>



<script type="text/javascript"><!--
var recurring_row = <?php echo $recurring_row; ?>;

function addRecurring() {
	recurring_row++;

	html  = '<tr id="recurring-row' + recurring_row + '">';
	html += '  <td class="left">';
	html += '    <select name="product_recurring[' + recurring_row + '][recurring_id]" class="form-control recurring-id">';
	<?php foreach ($recurrings as $recurring) { ?>
	html += '      <option value="<?php echo $recurring['recurring_id']; ?>"><?php echo $recurring['name']; ?></option>';
	<?php } ?>
	html += '    </select>';
	html += '  </td>';
	html += '  <td class="left">';
	html += '    <select name="product_recurring[' + recurring_row + '][customer_group_id]" class="form-control recurring-group">';
	<?php foreach ($customer_groups as $customer_group) { ?>
	html += '      <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>';
	<?php } ?>
	html += '    <select>';
	html += '  </td>';
	html += '  <td class="left"><a onclick="$(\'#recurring-row' + recurring_row + '\').remove()" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></a></td>';
	html += '</tr>';

	$('#tab-recurring table tbody').append(html);
}
//--></script>



<script type="text/javascript"><!--
$('#language a:first').tab('show');
$('#option a:first').tab('show');
//--></script>



<script type="text/javascript"><!--
$(function(){

	var $tabOption = $('#tab-option');

	// trata a alteração do campo "Gerar combinações?"
	$tabOption.on('change', '.input-option-combination', function(){
		var $parent = $('#' + this.id.replace('input-combination', 'tab-option'));

		if (this.value == '1') {
			$parent.addClass('has-combination');
		} else {
			$parent.removeClass('has-combination');
		}

		showHideCombinations();
	});

	// trata da exclusão de opções
	var $navOption = $('#option');

	$navOption.on('click', '.fa', function(){
		if (!confirm('<?php echo $button_remove; ?>?')) {
			return false;
		}

		var $this = $(this);
		var $link = $this.parent();
		var id = $link.attr('href');

		$(id).remove();
		$link.parent().remove();

		$navOption.find('a:first').tab('show');

		showHideCombinations();
	});

	// trata a alteração dos valores das opções
	$tabOption.on('change', '.input-option-value-id, .input-option-price-prefix, .input-option-points-prefix, .input-option-weight-prefix, .input-option-price, .input-option-points, .input-option-weight', function(){
		var hasCombination = $(this).parents('.has-combination').length;

		if (hasCombination > 0) {
			timedRefreshCombinations();
		}
	});

	// trata da exclusão dos valores das opções
	$tabOption.on('click', '.button-option-remove', function(){
		if (!confirm('<?php echo $button_remove; ?>?')) {
			return false;
		}

		var $this = $(this);
		var hasCombination = $this.parents('.has-combination').length;

		$this.tooltip('destroy');
		$this.parent().parent().remove();

		if (hasCombination > 0) {
			timedRefreshCombinations();
		}
	});

	// trata a alteração dos valores do produto
	$('body').on('change', '#input-price, #input-points, #input-weight', function(){
		var hasCombination = $tabOption.find('.has-combination').length;

		if (hasCombination > 0) {
			drawCombinations();
		}
	});



	// esconde/exibe abas e campos de acordo com o uso de combinações
	var $tabStock = $('#tab-stock');
	var $tabCombination = $('#tab-combination');
	var $tabCombinationLink = $('#tab-combination-link');

	function showHideCombinations() {
		var hasCombinations = $tabOption.find('.has-combination').length;

		if (hasCombinations > 0) {
			$tabCombinationLink.show();
			$tabStock.addClass('has-combination');
		} else {
			$tabCombinationLink.hide();
			$tabStock.removeClass('has-combination');
		}

		timedRefreshCombinations();
	}

	var timeoutRefreshCombinations;

	function timedRefreshCombinations() {
		clearTimeout(timeoutRefreshCombinations);
		timeoutRefreshCombinations = setTimeout(refreshCombinations, 1000);
	}



	// trata da geração das combinações
	var combinations = [];
	var combinations_values = <?php echo count($combinations) ? json_encode($combinations) : '{}'; ?>;

	var $combination = $('#combination');
	var $combinationTbody = $combination.find('tbody');

	function resetCombinations() {
		combinations = [];
	}

	function refreshCombinations() {
		// apaga combinações antigas
		resetCombinations();

		var options = [];
		var $optionsWithCombination = $tabOption.find('.has-combination');

		// constrói o array com as novas opções
		$optionsWithCombination.each(function(o){
			var $o = $(this);

			// busca os valores adicionados a esta opção
			var $optionValues = $o.find('.table tbody tr');

			// ignora esta opção caso não tenha nenhum valor adicionado
			if ($optionValues.length == 0) {
				return; // apenas "return" pois "return false" finaliza o loop
			}

			// pega mais informações desta opção
			var option_id = $o.find('.input-option-id').val();
			var option_name = $o.find('.input-option-name').val();
			var option_sort_order = $o.find('.input-option-sort').val();

			// trata sort_order (transforma em número ou zero)
			option_sort_order = _parseIntOrZero(option_sort_order, 10);

			var option_values = [];

			// verifica se esta opção já foi inserida anteriormente
			// e adiciona os novos valores no mesmo índice
			if (options[option_id] && options[option_id].values) {
				option_values = options[option_id].values;
			}

			// constrói o array com os valores desta opção
			$optionValues.each(function(ov){
				var $ov = $(this);

				var optionValue = $ov.find('.input-option-value-id')[0];
				var optionValueSelected = optionValue.options[optionValue.selectedIndex];

				// pega mais informações deste valor de opção
				var option_value_id            = optionValueSelected.value;
				var option_value_name          = optionValueSelected.text;
				var option_value_sort_order    = optionValueSelected.getAttribute('data-sort-order');
				var option_value_quantity      = $ov.find('.input-option-quantity').val();
				var option_value_subtract      = $ov.find('.input-option-subtract').val();
				var option_value_price_prefix  = $ov.find('.input-option-price-prefix').val();
				var option_value_price         = $ov.find('.input-option-price').val();
				var option_value_points_prefix = $ov.find('.input-option-points-prefix').val();
				var option_value_points        = $ov.find('.input-option-points').val();
				var option_value_weight_prefix = $ov.find('.input-option-weight-prefix').val();
				var option_value_weight        = $ov.find('.input-option-weight').val();

				// trata sort_order (transforma em número ou zero)
				option_value_sort_order = _parseIntOrZero(option_value_sort_order, 10);

				// trata da quantidade (transforma em número ou zero)
				option_value_quantity = _parseIntOrZero(option_value_quantity, 10);

				option_value_subtract = (option_value_subtract == '1');

				// trata prefixo dos valores
				option_value_price_prefix = option_value_price_prefix.replace(/[^+-]/g, '');
				option_value_points_prefix = option_value_points_prefix.replace(/[^+-]/g, '');
				option_value_weight_prefix = option_value_weight_prefix.replace(/[^+-]/g, '');

				// trata os valores (transforma em número ou zero)
				option_value_price  = _numberOrZero(option_value_price_prefix + option_value_price);
				option_value_points = _numberOrZero(option_value_points_prefix + option_value_points);
				option_value_weight = _numberOrZero(option_value_weight_prefix + option_value_weight);

				// insere as informações no array de valores
				option_values[option_value_id] = {
					'id': option_value_id,
					'name': option_value_name,
					'quantity': option_value_quantity,
					'subtract': option_value_subtract,
					'price': option_value_price,
					'points': option_value_points,
					'weight': option_value_weight,
					'sort_order': option_value_sort_order
				};
			});

			// insere ou atualiza as informações no array de opções
			options[option_id] = {
				'id': option_id,
				'name': option_name,
				'values': option_values,
				'sort_order': option_sort_order
			}
		});

		if (options.length > 0) {
			var temp_options = [];

			// limpa os itens vazios do array de opções
			$.each(options, function(i1, v1){
				if (v1 && v1.values && v1.values.length > 0) {
					var temp_options_values = [];

					// limpa os itens vazios do array de valores de opções
					$.each(v1.values, function(i2, v2){
						if (v2 && v2.id) {
							temp_options_values.push(v2);
						}
					});

					// ordena os valores das opções
					temp_options_values.sort(sortCombinationsByOrderAndName);

					// atualiza os valores desta opção
					v1.values = temp_options_values;

					temp_options.push(v1);
				}
			});

			// atualiza o array com as opções limpas
			options = temp_options;

			// ordena as opções
			options.sort(sortCombinationsByOrderAndName);

			// gera todas as combinações (recursivamente)
			combinations = generateCombinations(options);
		}

		// atualiza tabela (visualização)
		drawCombinations();
	}

	function sortCombinationsByOrderAndName(a, b) {
		// equivalente a:
		// sort_order ASC, name ASC (case insensitive)
		if (a['sort_order'] == b['sort_order']) {
			var name_a = a['name'].toUpperCase();
			var name_b = b['name'].toUpperCase();
			return (name_a > name_b) - (name_b > name_a);
		}

		return a['sort_order'] - b['sort_order'];
	}

	function sortCombinationsById(a, b) {
		// equivalente a:
		// id ASC
		return a['id'] - b['id'];
	}

	function sortIDsNumeric(a, b) {
		a = _numberOrZero(a);
		b = _numberOrZero(b);
		return a - b;
	}

	function generateCombinations(options, index) {
		index = _parseIntOrZero(index, 10);

		if (index < options.length && options[index] && options[index].values) {
			var values = {};
			var next_values = generateCombinations(options, index + 1);

			if (next_values) {
				$.each(options[index].values, function(i1, v1){
					$.each(next_values, function(i2, v2){
						// concatena os IDs e ordena de forma crescente
						var id = v1.id.split('-').concat(v2.id.split('-')).sort(sortIDsNumeric).join('-');
						var name = v1.name + ' > ' + v2.name;

						var quantity = Math.min(v1.quantity, v2.quantity);
						var subtract = v1.subtract && v2.subtract;

						var price  = v1.price + v2.price;
						var points = v1.points + v2.points;
						var weight = v1.weight + v2.weight;

						values[id] = {
							'id': id,
							'name': name,
							'quantity': quantity,
							'subtract': subtract,
							'price': price,
							'points': points,
							'weight': weight
						};
					});
				});
			} else {
				values = options[index].values;
			}

			return values;
		}

		return false;
	}

	var $combinationTotal = $('#combination-total');

	function drawCombinations() {
		$combinationTbody.html('');

		var price = $('#input-price').val();
		var points = $('#input-points').val();
		var weight = $('#input-weight').val();

		// transforma em int ou float
		price  = _numberOrZero(price);
		points = _numberOrZero(points);
		weight = _numberOrZero(weight);

		var total = 0;

		$.each(combinations, function(i, v){
			var html = '';

			var active   = 1;
			var sku      = '';
			var quantity = v.quantity;
			var subtract = v.subtract;
			var image    = '';

			var comb = combinations_values[v.id];

			if (comb) {
				active   = comb.active;
				sku      = comb.sku;
				quantity = comb.quantity;
				subtract = comb.subtract;
				image    = comb.image;
			} else {
				comb = {
					active   : active,
					sku      : sku,
					quantity : quantity,
					subtract : subtract,
					image    : image
				};
				combinations_values[v.id] = comb;
			}

			var tmp_price  = price + v.price;
			var tmp_points = points + v.points;
			var tmp_weight = weight + v.weight;

			tmp_price  = (tmp_price  < 0) ? 0 : +(tmp_price.toFixed(6));
			tmp_points = (tmp_points < 0) ? 0 : +(tmp_points.toFixed(6));
			tmp_weight = (tmp_weight < 0) ? 0 : +(tmp_weight.toFixed(6));

			html += '<tr id="combination-'+ v.id +'" class="combination-item">';
			html += '  <td class="text-center">';
			html += '    <input type="hidden" name="combination['+ total +'][combination]" class="combination-combination" value="'+ v.id +'">';
			html += '    <input type="hidden" name="combination['+ total +'][image]" class="combination-image" value="">';
			html += '    <input type="checkbox" name="combination['+ total +'][active]" value="1" class="combination-active" '+ (active ? 'checked' : '') +'>';
			html += '  </td>';
			html += '  <td><span>'+ v.name +'</span></td>';
			html += '  <td class="text-right"><span>'+ tmp_price +'</span></td>';
			html += '  <td class="text-right"><span>'+ tmp_points +'</span></td>';
			html += '  <td class="text-right"><span>'+ tmp_weight +'</span></td>';
			html += '  <td>';
			html += '    <input type="text" name="combination['+ total +'][sku]" class="form-control combination-sku" value="'+ sku +'">';
			html += '  </td>';
			html += '  <td>';
			html += '    <input type="text" name="combination['+ total +'][quantity]" class="form-control combination-quantity" value="'+ quantity +'">';
			html += '  </td>';
			html += '  <td class="text-center">';
			html += '    <input type="checkbox" name="combination['+ total +'][subtract]" value="1" class="combination-subtract" '+ (subtract ? 'checked' : '') +'>';
			html += '  </td>';
			html += '</tr>';

			$combinationTbody.append(html);
			total++;
		});

		$combinationTotal.html(total);
	}



	// trata da alteração dos valores das combinações
	// guarda os valores atualizados para possível auto-preenchimento posterior
	$combinationTbody.on('change', '.combination-active, .combination-sku, .combination-quantity, .combination-subtract', function(){
		var $this = $(this);
		var combination = $this.parents('.combination-item').find('.combination-combination').val();

		if ($this.hasClass('combination-active')) {
			combinations_values[combination].active = $this.prop('checked');

		} else if ($this.hasClass('combination-sku')) {
			combinations_values[combination].sku = $this.val();

		} else if ($this.hasClass('combination-quantity')) {
			var quantity = _forceIntOrZero($this.val());
			$this.val(quantity);
			combinations_values[combination].quantity = quantity;

		} else if ($this.hasClass('combination-subtract')) {
			combinations_values[combination].subtract = $this.prop('checked');
		}
	});



	// trata os checkbox select all
	$combination.on('click', '#combination-all-active', function(){
		var checked = this.checked;
		$combinationTbody.find('.combination-active').prop('checked', checked).trigger('change');
	});
	$combination.on('click', '#combination-all-subtract', function(){
		var checked = this.checked;
		$combinationTbody.find('.combination-subtract').prop('checked', checked).trigger('change');
	});



	// inicia combinações
	var $optionCombination = $tabOption.find('.input-option-combination');

	if ($optionCombination.length > 0) {
		$optionCombination.trigger('change');
	} else {
		showHideCombinations();
	}



	// funções de ajuda

	function _parseIntOrZero(num, base) {
		base = +(base);
		base = isNaN(base) ? 10 : base;

		num = parseInt(num, base);
		return isNaN(num) ? 0 : num;
	}

	function _numberOrZero(num) {
		num = +(num);
		return isNaN(num) ? 0 : num;
	}

	function _forceIntOrZero(num) {
		return +(('' + num).replace(/[^0-9]/g, ''));
	}

});
//--></script>



<script src="//cdnjs.cloudflare.com/ajax/libs/speakingurl/9.0.0/speakingurl.min.js" type="text/javascript"></script>
<script src="view/javascript/jquery/jquery.stringtoslug.min.js" type="text/javascript"></script>

<script>
$(function(){

	var $inputName = $('.input-name');
	var $inputMetaTitle = $('.input-meta-title');
	var $inputKeyword = $('#input-keyword');

	// preenche automaticamente os campos nome e meta title em outros idiomas
	$inputName.on('change', function(){
		var new_value = $.trim( this.value );
		this.value = new_value;

		if (new_value != '') {
			$inputName.each(function(i, el){
				el.value = $.trim( el.value );
				if (el.value == '') {
					el.value = new_value;
				}
			});

			$inputMetaTitle.each(function(i, el){
				el.value = $.trim( el.value );
				if (el.value == '') {
					el.value = new_value;
				}
			});
		}
	});

	$($inputName[0]).on('change', function(){
		var new_value = $.trim( this.value );
		this.value = new_value;

		if (new_value != '') {
			if ($inputKeyword.val() == '') {
				$inputKeyword.val(new_value).trigger('change');
			} else {
				if (confirm('O nome deste produto foi modificado. Deseja atualizar também sua URL amigável?')) {
					$inputKeyword.val(new_value).trigger('change');
				}
			}
		}
	});

	// preenche automaticamente o campo meta title em outros idiomas
	$inputMetaTitle.on('change', function(){
		var new_value = $.trim( this.value );
		this.value = new_value;

		if (new_value != '') {
			$inputMetaTitle.each(function(i, el){
				el.value = $.trim( el.value );
				if (el.value == '') {
					el.value = new_value;
				}
			});
		}
	});

	$inputKeyword.stringToSlug({
		setEvents: 'change blur',
		getPut: '#input-keyword',
		space: '-',
		AND: 'e'
	});

});
</script>



<script>
$(function(){

	var $form = $('#form-product');
	var $shipping = $('input[name="shipping"]:checked');
	var $length   = $('input[name="length"]');
	var $width    = $('input[name="width"]');
	var $height   = $('input[name="height"]');
	var $weight   = $('input[name="weight"]');

	$form.on('submit', function(e){
		var shipping = $shipping.val();

		if (shipping == 1) {
			var length, width, height, weight;

			length = $.trim( $length.val() );
			width  = $.trim( $width.val() );
			height = $.trim( $height.val() );
			weight = $.trim( $weight.val() );

			$length.val(length);
			$width.val(width);
			$height.val(height);
			$weight.val(weight);

			length = parseFloat(length);
			width  = parseFloat(width);
			height = parseFloat(height);
			weight = parseFloat(weight);

			if (isNaN(length) || length <= 0 || isNaN(width) || width <= 0 || isNaN(height) || height <= 0) {
				if (confirm('ATENÇÃO! As dimensões do produto (comprimento, largura e/ou altura) não foram preenchidas ou estão com valor ZERO. Sem estas informações NÃO será possível fazer o cálculo de frete, ou seja, a loja NÃO exibirá opções de frete para este produto! Deseja continuar assim mesmo?')) {
					return true;
				} else {
					$('a[href="#tab-data"]').click();
					if (isNaN(length) || length <= 0) { $length.focus(); } else if (isNaN(width) || width <= 0) { $width.focus(); } else { $height.focus(); }
					return false;
				}
			}

			if (isNaN(weight) || weight <= 0) {
				if (confirm('ATENÇÃO! O peso do produto não foi preenchido ou está com valor ZERO. Sem esta informação NÃO será possível fazer o cálculo de frete, ou seja, a loja NÃO exibirá opções de frete para este produto! Deseja continuar assim mesmo?')) {
					return true;
				} else {
					$('a[href="#tab-data"]').click();
					$weight.focus();
					return false;
				}
			}
		}

		return true;
	});

});
</script>



<script type="text/javascript"><!--
$("#qsave").on("click",function(){
for(var zz=$(".note-editor").length,i=0;zz>i;i++){var yy=$(".note-editor").eq(i).parent().children("textarea").attr("id");if("function"==typeof $().code)var content=$("#"+yy).code();else var content=$("#"+yy).summernote("code");$("#"+yy).html(content)}
$.ajax({type:"post",data:$("form").serialize(),url:"index.php?route=catalog/product/qsave&token=<?php echo $token; ?>&product_id=<?php echo $pidqs; ?>",dataType:"json",beforeSend:function(){$("#qsave").prop("disabled",!0)},complete:function(){$("#qsave").prop("disabled",!1)},success:function(e){if($(".alert").remove(),$(".text-danger").remove(),$(".form-group").removeClass("has-error"),e.error){if(html='<div class="alert alert-danger">',html+=" "+e.error.warning+' <button type="button" class="close" data-dismiss="alert">&times;</button></br>',e.error.model&&($("#input-model").after('<div class="text-danger">'+e.error.model+"</div>"),html+='</br><i class="fa fa-exclamation-circle"></i> '+e.error.model),e.error.keyword&&($("#input-keyword").after('<div class="text-danger">'+e.error.keyword+"</div>"),html+='</br><i class="fa fa-exclamation-circle"></i> '+e.error.keyword),e.error.name){var r="";for(i in e.error.name){var a=$("#input-name"+i);$(a).parent().hasClass("input-group")?($(a).parent().after('<div class="text-danger">'+e.error.name[i]+"</div>"),r='</br><i class="fa fa-exclamation-circle"></i> '+e.error.name[i]):($(a).after('<div class="text-danger">'+e.error.name[i]+"</div>"),r='</br><i class="fa fa-exclamation-circle"></i> '+e.error.name[i])}html+=r}if(e.error.meta_title){var r="";for(i in e.error.meta_title){var a=$("#input-meta-title"+i);$(a).parent().hasClass("input-group")?($(a).parent().after('<div class="text-danger">'+e.error.meta_title[i]+"</div>"),r='</br><i class="fa fa-exclamation-circle"></i> '+e.error.meta_title[i]):($(a).after('<div class="text-danger">'+e.error.meta_title[i]+"</div>"),r='</br><i class="fa fa-exclamation-circle"></i> '+e.error.meta_title[i])}html+=r}$(".text-danger").parentsUntil(".form-group").parent().addClass("has-error"),html+=" </div>",$("#content > .container-fluid").prepend(html)}e.success&&$("#content > .container-fluid").prepend('<div class="alert alert-success"><i class="fa fa-check-circle"></i> '+e.success+'  <button type="button" class="close" data-dismiss="alert">&times;</button></div>')},error:function(e,r,a){alert(a+"\r\n"+e.statusText+"\r\n"+e.responseText)}})});
//--></script>



<?php echo $footer; ?>