function getURLVar(key) {
	var value = [];

	var query = String(document.location).split('?');

	if (query[1]) {
		var part = query[1].split('&');

		for (i = 0; i < part.length; i++) {
			var data = part[i].split('=');

			if (data[0] && data[1]) {
				value[data[0]] = data[1];
			}
		}

		if (value[key]) {
			return value[key];
		} else {
			return '';
		}
	}
}

$(document).ready(function() {

	//Form Submit for IE Browser
	$('button[type=\'submit\'][form]').on('click', function(e) {
		e.preventDefault();
		$("form[id*='form-']").submit();
	});

	// Highlight any found errors
	$('.text-danger').each(function() {
		var element = $(this).parent().parent();

		if (element.hasClass('form-group')) {
			element.addClass('has-error');
		}
	});

	// Set last page opened on the menu
	$('#menu a[href]').on('click', function() {
		sessionStorage.setItem('menu', $(this).attr('href'));
	});

	if (!sessionStorage.getItem('menu')) {
		$('#menu #dashboard').addClass('active');
	} else {
		// Sets active and open to selected page in the left column menu.
		$('#menu a[href=\'' + sessionStorage.getItem('menu') + '\']').parents('li').addClass('active open');
	}

	if (localStorage.getItem('column-left') == 'active') {
		$('#button-menu i').replaceWith('<i class="fa fa-dedent fa-lg"></i>');

		$('#column-left').addClass('active');

		// Slide Down Menu
		$('#menu li.active').has('ul').children('ul').addClass('collapse in');
		$('#menu li').not('.active').has('ul').children('ul').addClass('collapse');
	} else {
		$('#button-menu i').replaceWith('<i class="fa fa-indent fa-lg"></i>');

		$('#menu li li.active').has('ul').children('ul').addClass('collapse in');
		$('#menu li li').not('.active').has('ul').children('ul').addClass('collapse');
	}

	// Menu button
	$('#button-menu').on('click', function() {
		// Checks if the left column is active or not.
		if ($('#column-left').hasClass('active')) {
			// localStorage.setItem('column-left', '');
			localStorage.setItem('column-left', 'not-active');

			$('#button-menu i').replaceWith('<i class="fa fa-indent fa-lg"></i>');

			$('#column-left').removeClass('active');

			$('#menu > li > ul').removeClass('in collapse');
			$('#menu > li > ul').removeAttr('style');
		} else {
			localStorage.setItem('column-left', 'active');

			$('#button-menu i').replaceWith('<i class="fa fa-dedent fa-lg"></i>');

			$('#column-left').addClass('active');

			// Add the slide down to open menu items
			$('#menu li.open').has('ul').children('ul').addClass('collapse in');
			$('#menu li').not('.open').has('ul').children('ul').addClass('collapse');
		}
	});

	// Menu
	$('#menu').find('li').has('ul').children('a').on('click', function() {
		if ($('#column-left').hasClass('active')) {
			$(this).parent('li').toggleClass('open').children('ul').collapse('toggle');
			$(this).parent('li').siblings().removeClass('open').children('ul.in').collapse('hide');
		} else if (!$(this).parent().parent().is('#menu')) {
			$(this).parent('li').toggleClass('open').children('ul').collapse('toggle');
			$(this).parent('li').siblings().removeClass('open').children('ul.in').collapse('hide');
		}
	});

	// Override summernotes image manager
	$('button[data-event=\'showImageDialog\']').attr('data-toggle', 'image').removeAttr('data-event');

	$(document).delegate('button[data-toggle=\'image\']', 'click', function() {
		$('#modal-image').remove();

		$(this).parents('.note-editor').find('.note-editable').focus();

		$.ajax({
			url: 'index.php?route=common/filemanager&type=editor&token=' + getURLVar('token'),
			dataType: 'html',
			beforeSend: function() {
				$('#button-image i').replaceWith('<i class="fa fa-circle-o-notch fa-spin"></i>');
				$('#button-image').prop('disabled', true);
			},
			complete: function() {
				$('#button-image i').replaceWith('<i class="fa fa-upload"></i>');
				$('#button-image').prop('disabled', false);
			},
			success: function(html) {
				$('body').append('<div id="modal-image" class="modal">' + html + '</div>');

				$('#modal-image').modal('show');
			}
		});
	});

	// Image Manager
	$(document).delegate('a[data-toggle=\'image\']', 'click', function(e) {
		e.preventDefault();

		$('.popover').popover('hide', function() {
			$('.popover').remove();
		});

		var element = this;

		$(element).popover({
			html: true,
			placement: 'right',
			trigger: 'manual',
			content: function() {
				return '<button type="button" id="button-image" class="btn btn-primary"><i class="fa fa-pencil"></i></button> <button type="button" id="button-clear" class="btn btn-danger"><i class="fa fa-trash-o"></i></button>';
			}
		});

		$(element).popover('show');

		$('#button-image').on('click', function() {
			$('#modal-image').remove();

			$.ajax({
				url: 'index.php?route=common/filemanager&type=image&token=' + getURLVar('token') + '&target=' + $(element).parent().find('input').attr('id') + '&thumb=' + $(element).attr('id'),
				dataType: 'html',
				beforeSend: function() {
					$('#button-image i').replaceWith('<i class="fa fa-circle-o-notch fa-spin"></i>');
					$('#button-image').prop('disabled', true);
				},
				complete: function() {
					$('#button-image i').replaceWith('<i class="fa fa-pencil"></i>');
					$('#button-image').prop('disabled', false);
				},
				success: function(html) {
					$('body').append('<div id="modal-image" class="modal">' + html + '</div>');

					$('#modal-image').modal('show');
				}
			});

			$(element).popover('hide', function() {
				$('.popover').remove();
			});
		});

		$('#button-clear').on('click', function() {
			$(element).find('img').attr('src', $(element).find('img').attr('data-placeholder'));

			$(element).parent().find('input').attr('value', '');

			$(element).popover('hide', function() {
				$('.popover').remove();
			});
		});
	});

	// tooltips on hover
	$('[data-toggle=\'tooltip\']').tooltip({container: 'body', html: true});

	// Makes tooltips work on ajax generated content
	$(document).ajaxStop(function() {
		$('[data-toggle=\'tooltip\']').tooltip({container: 'body'});
	});

	// https://github.com/opencart/opencart/issues/2595
	$.event.special.remove = {
		remove: function(o) {
			if (o.handler) {
				o.handler.apply(this, arguments);
			}
		}
	}

	$('[data-toggle=\'tooltip\']').on('remove', function() {
		$(this).tooltip('destroy');
	});
});

// Autocomplete */
(function($) {
	$.fn.autocomplete = function(option) {
		return this.each(function() {
			this.timer = null;
			this.items = new Array();

			$.extend(this, option);

			$(this).attr('autocomplete', 'off');

			// Focus
			$(this).on('focus', function() {
				this.request();
			});

			// Blur
			$(this).on('blur', function() {
				setTimeout(function(object) {
					object.hide();
				}, 200, this);
			});

			// Keydown
			$(this).on('keydown', function(event) {
				switch(event.keyCode) {
					case 27: // escape
						this.hide();
						break;
					default:
						this.request();
						break;
				}
			});

			// Click
			this.click = function(event) {
				event.preventDefault();

				value = $(event.target).parent().attr('data-value');

				if (value && this.items[value]) {
					this.select(this.items[value]);
				}
			}

			// Show
			this.show = function() {
				var pos = $(this).position();

				$(this).siblings('ul.dropdown-menu').css({
					top: pos.top + $(this).outerHeight(),
					left: pos.left
				});

				$(this).siblings('ul.dropdown-menu').show();
			}

			// Hide
			this.hide = function() {
				$(this).siblings('ul.dropdown-menu').hide();
			}

			// Request
			this.request = function() {
				clearTimeout(this.timer);

				this.timer = setTimeout(function(object) {
					object.source($(object).val(), $.proxy(object.response, object));
				}, 200, this);
			}

			// Response
			this.response = function(json) {
				html = '';

				if (json.length) {
					for (i = 0; i < json.length; i++) {
						this.items[json[i]['value']] = json[i];
					}

					for (i = 0; i < json.length; i++) {
						if (!json[i]['category']) {
							html += '<li data-value="' + json[i]['value'] + '"><a href="#">' + json[i]['label'] + '</a></li>';
						}
					}

					// Get all the ones with a categories
					var category = new Array();

					for (i = 0; i < json.length; i++) {
						if (json[i]['category']) {
							if (!category[json[i]['category']]) {
								category[json[i]['category']] = new Array();
								category[json[i]['category']]['name'] = json[i]['category'];
								category[json[i]['category']]['item'] = new Array();
							}

							category[json[i]['category']]['item'].push(json[i]);
						}
					}

					for (i in category) {
						html += '<li class="dropdown-header">' + category[i]['name'] + '</li>';

						for (j = 0; j < category[i]['item'].length; j++) {
							html += '<li data-value="' + category[i]['item'][j]['value'] + '"><a href="#">&nbsp;&nbsp;&nbsp;' + category[i]['item'][j]['label'] + '</a></li>';
						}
					}
				}

				if (html) {
					this.show();
				} else {
					this.hide();
				}

				$(this).siblings('ul.dropdown-menu').html(html);
			}

			$(this).after('<ul class="dropdown-menu"></ul>');
			$(this).siblings('ul.dropdown-menu').delegate('a', 'click', $.proxy(this.click, this));

		});
	}
})(window.jQuery);










function sortCustomFields($parent, element) {
	element = !element ? '.form-group' : element + '';

	$parent.find(element + '[data-sort]').detach().each(function() {
		var sort = $(this).attr('data-sort');
		var formGroups = $parent.find(element);

		if (sort >= 0 && sort < formGroups.length) {
			formGroups.eq(sort).before(this);
		}

		if (sort >= formGroups.length) {
			formGroups.filter(':last').after(this);
		}

		if (sort < 0) {
			formGroups.filter(':first').before(this);
		}
	});
}





$(document).on('focus.initDatetimepicker', '.date, .time, .datetime, .birth', function() {
	var $this = $(this);

	if ($this.hasClass('datetimepicker-on')) {
		return;
	}

	$this.addClass('datetimepicker-on');

	if ($this.hasClass('birth')) {
		$this.datetimepicker({
			allowInputToggle: true,
			showClear: true,
			showClose: true,
			locale: current_language_code,
			viewMode: 'years',
			useCurrent: false,
			maxDate: birth_max_date,
			viewDate: birth_max_date
		});
		return;
	}

	$this.datetimepicker({
		allowInputToggle: true,
		showClear: true,
		showClose: true,
		useCurrent: false,
		locale: current_language_code
	});
});





function validaCPF(b){if(!RegExp("^[0-9]{11}$").test(b)&&!RegExp("^[0-9]{3}.[0-9]{3}.[0-9]{3}-[0-9]{2}$").test(b))return!1;for(b=b.replace(/[^0-9]/g,""),a=0;a<10;a++)if(RegExp("^"+a+"{11}$").test(b))return!1;var c=b.split("",9);for(d=9;d<=10;d++){var e=d+1,f=0;for(a=0;a<d;a++)f+=c[a]*e--;var g=f%11;c[d]=2>g?0:11-g}return b.substr(9,2)!=""+c[9]+c[10]?!1:!0}
function validaCNPJ(b){if(!RegExp("^[0-9]{14,15}$").test(b)&&!RegExp("^[0-9]{2,3}.[0-9]{3}.[0-9]{3}/[0-9]{4}-[0-9]{2}$").test(b))return!1;if(b=b.replace(/[^0-9]/g,""),15==b.length){if(0!=b.substr(0,1))return!1;b=b.substr(1,14)}for(a=0;a<10;a++)if(RegExp("^"+a+"{14}$").test(b))return!1;var c=b.split("",12);for(d=12;d<=13;d++){var e=d-7,f=0;for(a=0;a<d;a++)f+=c[a]*e--,2>e&&(e=9);var g=f%11;c[d]=2>g?0:11-g}return b.substr(12,2)!=""+c[12]+c[13]?!1:!0}





function inputPhoneBrasilChange(e){
	if (e.type == 'keyup' && $.inArray(parseInt(e.keyCode), [9, 16, 17, 18, 35, 36, 37, 38, 39, 40]) > -1){ return true; }
	var length = this.value.replace(/[^0-9]/g, '').length;
	if (e.type == 'keyup' && length < 10) { return true; }
	$(this).mask( length > 10 ? '(99) 99999-999?9' : '(99) 9999-9999?9' );
}





var returnedCeps = [];

function inputPostcodeBrasilChange(e){
	var cep = this.value.replace(/[^0-9]/g, '');
	if (cep.length < 8) { return true; }

	var $this = $(this);
	var lastCep = $this.data('last-cep');

	if (lastCep == cep) { return true; }
	$this.data('last-cep', cep);

	var returnedCepsLength = returnedCeps.length;

	// verifica se esta no cache
	for(a=0; a < returnedCepsLength; a++){
		if(returnedCeps[a].cep == cep){
			// se estiver no cache retorna
			afterChangePostcodeBrasil(returnedCeps[a].json, $this);
			return true;
		}
	}

	var xhrCep = $this.data('xhr-cep');

	if(xhrCep && xhrCep.readyState != 4){
		xhrCep.abort();
	}

	xhrCep = $.ajax({
		url: 'index.php?route=sale/customer/consulta_cep&token=' + oc_session_token + '&c=' + cep,
		dataType: 'json',
		beforeSend: function() {
			$('.fa-spin').remove();
			$this.after(' <i class="fa fa-circle-o-notch fa-spin country-loading"></i>');
		},
		complete: function() {
			$('.fa-spin').remove();
		},
		success: function(json) {
			afterChangePostcodeBrasil(json, $this);
			returnedCeps.push({cep:cep, json:json});
		},
		error: function(xhr, ajaxOptions, thrownError) {
			if (thrownError != 'abort') {
				alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
			}
		}
	});

	$this.data('xhr-cep', xhrCep);
}

function afterChangePostcodeBrasil(json, $this) {
	if (json['resultado'] == '1') {
		var $parent = $this.parents('.form-register');

		$parent.find('.input-address-1').val(unescape(json['tipo_logradouro'])+' '+unescape(json['logradouro']));
		$parent.find('.input-address-2').val(unescape(json['bairro']));
		$parent.find('.input-city').val(unescape(json['cidade']));

		var $inputZone = $parent.find('.input-zone');
		$inputZone.find('option').removeAttr('selected');
		$inputZone.find('option[data-code=' + unescape(json['uf']) + ']').attr('selected', 'selected');

		$parent.find('.input-numero').trigger('focus');
	} else {
		alert("Não foi possível encontrar o endereço para o CEP informado. Por favor, digite manualmente seu endereço!");
	}
}





function initFormRegister() {

	$(document).on('keyup.maskPostcode blur.maskPostcode' ,'.mask-postcode-on', inputPostcodeBrasilChange);
	$(document).on('keyup.maskPhone blur.maskPhone' ,'.mask-phone-on', inputPhoneBrasilChange);

	$(document).on('change.inputCountry', '.input-country', function() {
		var val = this.options[this.selectedIndex].value;
		var txt = $.trim(this.options[this.selectedIndex].text).toLowerCase();

		var $this = $(this);
		var $form = $this.parents('.form-register');

		var $fieldsetBrasil    = $form.find('.fieldset-brasil');
		var $inputMaskPostcode = $form.find('.mask-postcode');
		var $inputMaskPhone    = $form.find('.mask-phone');

		if (txt == 'brasil' || txt == 'brazil') {
			$fieldsetBrasil.show();
			$inputMaskPostcode.not('.mask-postcode-on').addClass('mask-postcode-on').mask('99999-999');
			$inputMaskPhone.not('.mask-phone-on').addClass('mask-phone-on').mask('(99) 9999-9999?9').trigger('keyup.maskPhone');
		} else {
			$fieldsetBrasil.hide();
			$inputMaskPostcode.removeClass('mask-postcode-on').unmask();
			$inputMaskPhone.removeClass('mask-phone-on').unmask();
		}

		$form.find('.hidden-country').val(val);
	});

	$(document).on('change.inputTipo', '.input-tipo', function() {
		var $this = $(this);
		var $parent = $this.parents('.form-group');
		var val = $parent.find(':checked').val();

		var $form = $this.parents('.form-register');
		var $fieldsetPF = $form.find('.fieldset-pessoa-fisica');
		var $fieldsetPJ = $form.find('.fieldset-pessoa-juridica');

		if (val == 'f') {
			$fieldsetPJ.hide();
			$fieldsetPF.show();
			return true;
		}
		if (val == 'j') {
			$fieldsetPF.hide();
			$fieldsetPJ.show();
			return true;
		}

		$fieldsetPJ.hide();
		$fieldsetPF.hide();
	});

	$(document).on('focus', '.mask-cpf', function() {
		$(this).mask('999.999.999-99').removeClass('mask-cpf').addClass('mask-cpf-on');
	});
	$(document).on('focus', '.mask-cnpj', function() {
		$(this).mask('99.999.999/9999-99').removeClass('mask-cnpj').addClass('mask-cnpj-on');
	});

	$(document).on('change.maskCPFCNPJ' ,'.mask-cpf-on, .mask-cnpj-on', function(){
		var $this = $(this);
		var $parent = $this.parents('.form-group');

		$parent.find('.text-danger').remove();
		$parent.removeClass('has-error');

		var val = $.trim(this.value);

		if (val == '') {
			return;
		}

		if ($this.hasClass('mask-cpf-on')) {
			if (!validaCPF(val)) {
				$this.after('<div class="text-danger">O CPF informado não é válido!</div>');
				$parent.addClass('has-error');
			}
		} else {
			if (!validaCNPJ(val)) {
				$this.after('<div class="text-danger">O CNPJ informado não é válido!</div>');
				$parent.addClass('has-error');
			}
		}
	});

	triggerFormRegister();
}

function triggerFormRegister() {
	$('.input-country').trigger('change.inputCountry');
	$('.input-tipo').trigger('change.inputTipo');
}









