<?php
class ControllerTotalDesconto extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('total/desconto');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('desconto', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_payment_method'] = $this->language->get('entry_payment_method');
		$data['entry_discount'] = $this->language->get('entry_discount');
		$data['entry_total'] = $this->language->get('entry_total');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['button_module_add'] = $this->language->get('button_module_add');
		$data['button_remove'] = $this->language->get('button_remove');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_total'),
			'href' => $this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('total/desconto', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('total/desconto', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL');


		$this->load->model('extension/extension');

		$payment_extensions = $this->model_extension_extension->getInstalled('payment');

		$payment_methods = array();
		$payment_methods_sort = array();

		foreach ($payment_extensions as $extension) {
			$this->load->language('payment/' . $extension);

			$payment_methods[] = array(
				'name' => $this->language->get('heading_title'),
				'code' => $extension
			);

			$payment_methods_sort[] = $this->language->get('heading_title');
		}

		array_multisort($payment_methods_sort, SORT_ASC, $payment_methods);

		$data['payment_methods'] = $payment_methods;


		if (isset($this->request->post['desconto_module'])) {
			$data['modules'] = $this->request->post['desconto_module'];
		} elseif ($this->config->get('desconto_module')) {
			$data['modules'] = $this->config->get('desconto_module');
		} else {
			$data['modules'] = array();
		}

		if (isset($this->request->post['desconto_status'])) {
			$data['desconto_status'] = $this->request->post['desconto_status'];
		} else {
			$data['desconto_status'] = $this->config->get('desconto_status');
		}

		if (isset($this->request->post['desconto_sort_order'])) {
			$data['desconto_sort_order'] = $this->request->post['desconto_sort_order'];
		} else {
			$data['desconto_sort_order'] = $this->config->get('desconto_sort_order');
		}


		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('total/desconto.tpl', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'total/desconto')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}