<?php
class ControllerShippingTotalExpress extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('shipping/totalexpress');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('totalexpress', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title']    = $this->language->get('heading_title');

		$data['text_enabled']     = $this->language->get('text_enabled');
		$data['text_disabled']    = $this->language->get('text_disabled');
		$data['text_all_zones']   = $this->language->get('text_all_zones');
		$data['text_none']        = $this->language->get('text_none');

		$data['entry_rate']       = $this->language->get('entry_rate');
		$data['entry_tax_class']  = $this->language->get('entry_tax_class');
		$data['entry_geo_zone']   = $this->language->get('entry_geo_zone');
		$data['entry_status']     = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_save']      = $this->language->get('button_save');
		$data['button_cancel']    = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_shipping'),
			'href' => $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('shipping/totalexpress', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('shipping/totalexpress', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL');

		$data['servicos_total'] = array(
			'ESP' => 'Especial',
			'EXP' => 'Expresso',
			'STD' => 'Standard',
			'PRM' => 'Premium'
		);

		if (isset($this->request->post['totalexpress_servicos'])) {
			$data['totalexpress_servicos'] = $this->request->post['totalexpress_servicos'];
		} else {
			$data['totalexpress_servicos'] = $this->config->get('totalexpress_servicos');
		}

		if (isset($this->request->post['totalexpress_geo_zone_id'])) {
			$data['totalexpress_geo_zone_id'] = $this->request->post['totalexpress_geo_zone_id'];
		} else {
			$data['totalexpress_geo_zone_id'] = $this->config->get('totalexpress_geo_zone_id');
		}

		if (isset($this->request->post['totalexpress_status'])) {
			$data['totalexpress_status'] = $this->request->post['totalexpress_status'];
		} else {
			$data['totalexpress_status'] = $this->config->get('totalexpress_status');
		}

		if (isset($this->request->post['totalexpress_sort_order'])) {
			$data['totalexpress_sort_order'] = $this->request->post['totalexpress_sort_order'];
		} else {
			$data['totalexpress_sort_order'] = $this->config->get('totalexpress_sort_order');
		}

		if (isset($this->request->post['totalexpress_nome'])) {
			$data['totalexpress_nome'] = $this->request->post['totalexpress_nome'];
		} else {
			$data['totalexpress_nome'] = $this->config->get('totalexpress_nome');
		}

		if (isset($this->request->post['totalexpress_tax_class_id'])) {
			$data['totalexpress_tax_class_id'] = $this->request->post['totalexpress_tax_class_id'];
		} else {
			$data['totalexpress_tax_class_id'] = $this->config->get('totalexpress_tax_class_id');
		}

		if (isset($this->request->post['totalexpress_minimo'])) {
			$data['totalexpress_minimo'] = $this->request->post['totalexpress_minimo'];
		} else {
			$data['totalexpress_minimo'] = $this->config->get('totalexpress_minimo');
		}

		if (isset($this->request->post['totalexpress_prazo_extra'])) {
			$data['totalexpress_prazo_extra'] = $this->request->post['totalexpress_prazo_extra'];
		} else {
			$data['totalexpress_prazo_extra'] = $this->config->get('totalexpress_prazo_extra');
		}

		if (isset($this->request->post['totalexpress_taxa_extra'])) {
			$data['totalexpress_taxa_extra'] = $this->request->post['totalexpress_taxa_extra'];
		} else {
			$data['totalexpress_taxa_extra'] = $this->config->get('totalexpress_taxa_extra');
		}

		if (isset($this->request->post['totalexpress_login'])) {
			$data['totalexpress_login'] = $this->request->post['totalexpress_login'];
		} else {
			$data['totalexpress_login'] = $this->config->get('totalexpress_login');
		}

		if (isset($this->request->post['totalexpress_senha'])) {
			$data['totalexpress_senha'] = $this->request->post['totalexpress_senha'];
		} else {
			$data['totalexpress_senha'] = $this->config->get('totalexpress_senha');
		}

		$tema = 'shipping/totalexpress.tpl';

		$this->load->model('localisation/tax_class');

		$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();


		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view($tema, $data));
	}

	private function validate() {
		return true;
	}
}
