<?php
class ControllerShippingJamef extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('shipping/jamef');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('jamef', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title']    = $this->language->get('heading_title');

		$data['text_enabled']     = $this->language->get('text_enabled');
		$data['text_disabled']    = $this->language->get('text_disabled');
		$data['text_all_zones']   = $this->language->get('text_all_zones');
		$data['text_none']        = $this->language->get('text_none');

		$data['entry_rate']       = $this->language->get('entry_rate');
		$data['entry_tax_class']  = $this->language->get('entry_tax_class');
		$data['entry_geo_zone']   = $this->language->get('entry_geo_zone');
		$data['entry_status']     = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_save']      = $this->language->get('button_save');
		$data['button_cancel']    = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_shipping'),
			'href' => $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('shipping/jamef', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('shipping/jamef', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['jamef_geo_zone_id'])) {
			$data['jamef_geo_zone_id'] = $this->request->post['jamef_geo_zone_id'];
		} else {
			$data['jamef_geo_zone_id'] = $this->config->get('jamef_geo_zone_id');
		}

		if (isset($this->request->post['jamef_status'])) {
			$data['jamef_status'] = $this->request->post['jamef_status'];
		} else {
			$data['jamef_status'] = $this->config->get('jamef_status');
		}

		if (isset($this->request->post['jamef_tipoa'])) {
			$data['jamef_tipoa'] = $this->request->post['jamef_tipoa'];
		} else {
			$data['jamef_tipoa'] = $this->config->get('jamef_tipoa');
		}

		if (isset($this->request->post['jamef_tipor'])) {
			$data['jamef_tipor'] = $this->request->post['jamef_tipor'];
		} else {
			$data['jamef_tipor'] = $this->config->get('jamef_tipor');
		}

		if (isset($this->request->post['jamef_sort_order'])) {
			$data['jamef_sort_order'] = $this->request->post['jamef_sort_order'];
		} else {
			$data['jamef_sort_order'] = $this->config->get('jamef_sort_order');
		}

		if (isset($this->request->post['jamef_user'])) {
			$data['jamef_user'] = $this->request->post['jamef_user'];
		} else {
			$data['jamef_user'] = $this->config->get('jamef_user');
		}

		if (isset($this->request->post['jamef_login'])) {
			$data['jamef_login'] = $this->request->post['jamef_login'];
		} else {
			$data['jamef_login'] = $this->config->get('jamef_login');
		}

		if (isset($this->request->post['jamef_cidade'])) {
			$data['jamef_cidade'] = $this->request->post['jamef_cidade'];
		} else {
			$data['jamef_cidade'] = $this->config->get('jamef_cidade');
		}

		if (isset($this->request->post['jamef_entrega'])) {
			$data['jamef_entrega'] = $this->request->post['jamef_entrega'];
		} else {
			$data['jamef_entrega'] = $this->config->get('jamef_entrega');
		}

		if (isset($this->request->post['jamef_filial'])) {
			$data['jamef_filial'] = $this->request->post['jamef_filial'];
		} else {
			$data['jamef_filial'] = $this->config->get('jamef_filial');
		}

		if (isset($this->request->post['jamef_uf'])) {
			$data['jamef_uf'] = $this->request->post['jamef_uf'];
		} else {
			$data['jamef_uf'] = $this->config->get('jamef_uf');
		}

		if (isset($this->request->post['jamef_nome'])) {
			$data['jamef_nome'] = $this->request->post['jamef_nome'];
		} else {
			$data['jamef_nome'] = $this->config->get('jamef_nome');
		}

		if (isset($this->request->post['jamef_prazo'])) {
			$data['jamef_prazo'] = $this->request->post['jamef_prazo'];
		} else {
			$data['jamef_prazo'] = $this->config->get('jamef_prazo');
		}

		if (isset($this->request->post['jamef_taxa'])) {
			$data['jamef_taxa'] = $this->request->post['jamef_taxa'];
		} else {
			$data['jamef_taxa'] = $this->config->get('jamef_taxa');
		}

		if (isset($this->request->post['jamef_peso_minimo'])) {
			$data['jamef_peso_minimo'] = $this->request->post['jamef_peso_minimo'];
		} else {
			$data['jamef_peso_minimo'] = $this->config->get('jamef_peso_minimo');
		}

		if (isset($this->request->post['jamef_total_minimo'])) {
			$data['jamef_total_minimo'] = $this->request->post['jamef_total_minimo'];
		} else {
			$data['jamef_total_minimo'] = $this->config->get('jamef_total_minimo');
		}

		if (isset($this->request->post['jamef_tax_class_id'])) {
			$data['jamef_tax_class_id'] = $this->request->post['jamef_tax_class_id'];
		} else {
			$data['jamef_tax_class_id'] = $this->config->get('jamef_tax_class_id');
		}

		$this->load->model('localisation/tax_class');

		$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('shipping/jamef.tpl', $data));
	}

	private function validate() {
		return true;
	}
}
