<?php
class ControllerShippingJadlog extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('shipping/jadlog');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('jadlog', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title']    = $this->language->get('heading_title');

		$data['text_enabled']     = $this->language->get('text_enabled');
		$data['text_disabled']    = $this->language->get('text_disabled');
		$data['text_all_zones']   = $this->language->get('text_all_zones');
		$data['text_none']        = $this->language->get('text_none');

		$data['entry_rate']       = $this->language->get('entry_rate');
		$data['entry_tax_class']  = $this->language->get('entry_tax_class');
		$data['entry_geo_zone']   = $this->language->get('entry_geo_zone');
		$data['entry_status']     = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_save']      = $this->language->get('button_save');
		$data['button_cancel']    = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_shipping'),
			'href' => $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('shipping/jadlog', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('shipping/jadlog', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL');

		$data['tiposFrete'] = array(
			'Expresso (aereo)'  => 0,
			'.Package'          => 3,
			'Rodoviario'        => 4,
			'Economico'         => 5,
			'DOC'               => 6,
			'Corporate (aereo)' => 7,
			'.COM (aereo)'      => 9,
			'Cargo (aereo)'     => 12
		);

		if (isset($this->request->post['jadlog_localidade'])) {
			$data['jadlog_localidade'] = $this->request->post['jadlog_localidade'];
		} else {
			$data['jadlog_localidade'] = $this->config->get('jadlog_localidade');
		}

		if (isset($this->request->post['jadlog_geo_zone_id'])) {
			$data['jadlog_geo_zone_id'] = $this->request->post['jadlog_geo_zone_id'];
		} else {
			$data['jadlog_geo_zone_id'] = $this->config->get('jadlog_geo_zone_id');
		}

		if (isset($this->request->post['jadlog_status'])) {
			$data['jadlog_status'] = $this->request->post['jadlog_status'];
		} else {
			$data['jadlog_status'] = $this->config->get('jadlog_status');
		}

		if (isset($this->request->post['jadlog_sort_order'])) {
			$data['jadlog_sort_order'] = $this->request->post['jadlog_sort_order'];
		} else {
			$data['jadlog_sort_order'] = $this->config->get('jadlog_sort_order');
		}

		if (isset($this->request->post['jadlog_tipos'])) {
			$data['jadlog_tipos'] = $this->request->post['jadlog_tipos'];
		} else {
			$data['jadlog_tipos'] = $this->config->get('jadlog_tipos');
		}

		if (isset($this->request->post['jadlog_user'])) {
			$data['jadlog_user'] = $this->request->post['jadlog_user'];
		} else {
			$data['jadlog_user'] = $this->config->get('jadlog_user');
		}

		if (isset($this->request->post['jadlog_senha'])) {
			$data['jadlog_senha'] = $this->request->post['jadlog_senha'];
		} else {
			$data['jadlog_senha'] = $this->config->get('jadlog_senha');
		}

		if (isset($this->request->post['jadlog_entrega'])) {
			$data['jadlog_entrega'] = $this->request->post['jadlog_entrega'];
		} else {
			$data['jadlog_entrega'] = $this->config->get('jadlog_entrega');
		}

		if (isset($this->request->post['jadlog_frete'])) {
			$data['jadlog_frete'] = $this->request->post['jadlog_frete'];
		} else {
			$data['jadlog_frete'] = $this->config->get('jadlog_frete');
		}

		if (isset($this->request->post['jadlog_cep'])) {
			$data['jadlog_cep'] = $this->request->post['jadlog_cep'];
		} else {
			$data['jadlog_cep'] = $this->config->get('jadlog_cep');
		}

		if (isset($this->request->post['jadlog_nome'])) {
			$data['jadlog_nome'] = $this->request->post['jadlog_nome'];
		} else {
			$data['jadlog_nome'] = $this->config->get('jadlog_nome');
		}

		if (isset($this->request->post['jadlog_prazo'])) {
			$data['jadlog_prazo'] = $this->request->post['jadlog_prazo'];
		} else {
			$data['jadlog_prazo'] = $this->config->get('jadlog_prazo');
		}

		if (isset($this->request->post['jadlog_prazoa'])) {
			$data['jadlog_prazoa'] = $this->request->post['jadlog_prazoa'];
		} else {
			$data['jadlog_prazoa'] = $this->config->get('jadlog_prazoa');
		}

		if (isset($this->request->post['jadlog_coleta'])) {
			$data['jadlog_coleta'] = $this->request->post['jadlog_coleta'];
		} else {
			$data['jadlog_coleta'] = $this->config->get('jadlog_coleta');
		}

		if (isset($this->request->post['jadlog_taxa'])) {
			$data['jadlog_taxa'] = $this->request->post['jadlog_taxa'];
		} else {
			$data['jadlog_taxa'] = $this->config->get('jadlog_taxa');
		}

		if (isset($this->request->post['jadlog_peso_minimo'])) {
			$data['jadlog_peso_minimo'] = $this->request->post['jadlog_peso_minimo'];
		} else {
			$data['jadlog_peso_minimo'] = $this->config->get('jadlog_peso_minimo');
		}

		if (isset($this->request->post['jadlog_total_minimo'])) {
			$data['jadlog_total_minimo'] = $this->request->post['jadlog_total_minimo'];
		} else {
			$data['jadlog_total_minimo'] = $this->config->get('jadlog_total_minimo');
		}

		if (isset($this->request->post['jadlog_tax_class_id'])) {
			$data['jadlog_tax_class_id'] = $this->request->post['jadlog_tax_class_id'];
		} else {
			$data['jadlog_tax_class_id'] = $this->config->get('jadlog_tax_class_id');
		}

		$this->load->model('localisation/tax_class');

		$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('shipping/jadlog.tpl', $data));
	}

	private function validate() {
		return true;
	}
}
