<?php
class ControllerShippingCorreios extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('shipping/correios');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('correios', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit']         = $this->language->get('text_edit');
		$data['text_enabled']      = $this->language->get('text_enabled');
		$data['text_disabled']     = $this->language->get('text_disabled');
		$data['text_all_zones']    = $this->language->get('text_all_zones');
		$data['text_none']         = $this->language->get('text_none');
		$data['text_yes']          = $this->language->get('text_yes');
		$data['text_no']           = $this->language->get('text_no');
		$data['text_select_all']   = $this->language->get('text_select_all');
		$data['text_unselect_all'] = $this->language->get('text_unselect_all');
		$data['text_total']        = $this->language->get('text_total');

		$data['entry_cost']              = $this->language->get('entry_cost');
		$data['entry_postcode']          = $this->language->get('entry_postcode');
		$data['entry_servicos']          = $this->language->get('entry_servicos');
		$data['entry_contrato']          = $this->language->get('entry_contrato');
		$data['entry_contrato_codigo']   = $this->language->get('entry_contrato_codigo');
		$data['entry_contrato_senha']    = $this->language->get('entry_contrato_senha');
		$data['entry_mao_propria']       = $this->language->get('entry_mao_propria');
		$data['entry_aviso_recebimento'] = $this->language->get('entry_aviso_recebimento');
		$data['entry_declarar_valor']    = $this->language->get('entry_declarar_valor');
		$data['entry_adicional']         = $this->language->get('entry_adicional');
		$data['entry_prazo_adicional']   = $this->language->get('entry_prazo_adicional');
		$data['entry_tax_class']         = $this->language->get('entry_tax_class');
		$data['entry_geo_zone']          = $this->language->get('entry_geo_zone');
		$data['entry_status']            = $this->language->get('entry_status');
		$data['entry_sort_order']        = $this->language->get('entry_sort_order');

		$data['help_servicos']          = $this->language->get('help_servicos');
		$data['help_contrato']          = $this->language->get('help_contrato');
		$data['help_mao_propria']       = $this->language->get('help_mao_propria');
		$data['help_aviso_recebimento'] = $this->language->get('help_aviso_recebimento');
		$data['help_declarar_valor']    = $this->language->get('help_declarar_valor');
		$data['help_adicional']         = $this->language->get('help_adicional');
		$data['help_prazo_adicional']   = $this->language->get('help_prazo_adicional');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_descontos'] = $this->language->get('tab_descontos');

		$data['servicos'] = array(
			'04510' => $this->language->get('text_pac_04510'),
			'04707' => $this->language->get('text_pac_cobrar_04707'),
			'04014' => $this->language->get('text_sedex_04014'),
			'04065' => $this->language->get('text_sedex_cobrar_04065'),
			'40215' => $this->language->get('text_sedex_10_40215'),
			'40169' => $this->language->get('text_sedex_12_40169'),
			'40290' => $this->language->get('text_sedex_hoje_40290'),

			'04669' => $this->language->get('text_pac_contrato_04669'),
			'04596' => $this->language->get('text_pac_contrato_04596'),
			'04693' => $this->language->get('text_pac_grandes_formatos_04693'),
			'04162' => $this->language->get('text_sedex_contrato_04162'),
			'04553' => $this->language->get('text_sedex_contrato_04553'),
			'40436' => $this->language->get('text_sedex_contrato_40436'),
			'40444' => $this->language->get('text_sedex_contrato_40444'),
			'40568' => $this->language->get('text_sedex_contrato_40568'),
			'40606' => $this->language->get('text_sedex_contrato_40606'),
			'40126' => $this->language->get('text_sedex_cobrar_contrato_40126'),

			// '81019' => $this->language->get('text_esedex_81019'),
			// '81027' => $this->language->get('text_esedex_prioritario_81027'),
			// '81035' => $this->language->get('text_esedex_express_81035'),
			// '81868' => $this->language->get('text_esedex_grupo1_81868'),
			// '81833' => $this->language->get('text_esedex_grupo2_81833'),
			// '81850' => $this->language->get('text_esedex_grupo3_81850'),
		);

		$servicos_old = array(
			'04510' => '41106', // PAC
			'04707' => '41262', // PAC a cobrar
			'04014' => '40010', // SEDEX
			'04065' => '40045', // SEDEX a cobrar
			'04669' => '41068', // PAC contrato
			'04693' => '41300', // PAC GF contrato
			'04162' => '40096', // SEDEX contrato
		);

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['postcode'])) {
			$data['error_postcode'] = $this->error['postcode'];
		} else {
			$data['error_postcode'] = '';
		}

		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
   		);
   		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_shipping'),
			'href' => $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL')
   		);
   		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('shipping/correios', 'token=' . $this->session->data['token'], 'SSL')
   		);

   		$data['action'] = $this->url->link('shipping/correios', 'token=' . $this->session->data['token'], 'SSL');

   		$data['cancel'] = $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['correios_postcode'])) {
			$data['correios_postcode'] = $this->request->post['correios_postcode'];
		} else {
			$data['correios_postcode'] = $this->config->get('correios_postcode');
		}
		if (isset($this->request->post['correios_contrato_codigo'])) {
			$data['correios_contrato_codigo'] = $this->request->post['correios_contrato_codigo'];
		} elseif ($this->config->get('correios_contrato_codigo') != '') {
			$data['correios_contrato_codigo'] = $this->config->get('correios_contrato_codigo');
		} else {
			$data['correios_contrato_codigo'] = $this->config->get('correios_esedex_codigo');
		}
		if (isset($this->request->post['correios_contrato_senha'])) {
			$data['correios_contrato_senha'] = $this->request->post['correios_contrato_senha'];
		} elseif ($this->config->get('correios_contrato_senha') != '') {
			$data['correios_contrato_senha'] = $this->config->get('correios_contrato_senha');
		} else {
			$data['correios_contrato_senha'] = $this->config->get('correios_esedex_senha');
		}
		if (isset($this->request->post['correios_mao_propria'])) {
			$data['correios_mao_propria'] = $this->request->post['correios_mao_propria'];
		} else {
			$data['correios_mao_propria'] = $this->config->get('correios_mao_propria');
		}
		if (isset($this->request->post['correios_aviso_recebimento'])) {
			$data['correios_aviso_recebimento'] = $this->request->post['correios_aviso_recebimento'];
		} else {
			$data['correios_aviso_recebimento'] = $this->config->get('correios_aviso_recebimento');
		}
		if (isset($this->request->post['correios_declarar_valor'])) {
			$data['correios_declarar_valor'] = $this->request->post['correios_declarar_valor'];
		} else {
			$data['correios_declarar_valor'] = $this->config->get('correios_declarar_valor');
		}
		if (isset($this->request->post['correios_adicional'])) {
			$data['correios_adicional'] = $this->request->post['correios_adicional'];
		} else {
			$data['correios_adicional'] = $this->config->get('correios_adicional');
		}
		if (isset($this->request->post['correios_prazo_adicional'])) {
			$data['correios_prazo_adicional'] = $this->request->post['correios_prazo_adicional'];
		} else {
			$data['correios_prazo_adicional'] = $this->config->get('correios_prazo_adicional');
		}

		foreach ($data['servicos'] as $s => $serv) {
			$data["correios_{$s}"] = '';
			if (isset($this->request->post["correios_{$s}"])) {
				$data["correios_{$s}"] = $this->request->post["correios_{$s}"];
			} else {
				if ($this->config->has("correios_{$s}")) {
					$data["correios_{$s}"] = $this->config->get("correios_{$s}");
				} else {
					if (isset($servicos_old[$s])) {
						$s_old = $servicos_old[$s];
						if ($this->config->has("correios_{$s_old}")) {
							$data["correios_{$s}"] = $this->config->get("correios_{$s_old}");
						}
					}
				}
			}

			$data["correios_total_{$s}"] = '';
			if (isset($this->request->post["correios_total_{$s}"])) {
				$data["correios_total_{$s}"] = $this->request->post["correios_total_{$s}"];
			} else {
				if ($this->config->has("correios_total_{$s}")) {
					$data["correios_total_{$s}"] = $this->config->get("correios_total_{$s}");
				} else {
					if (isset($servicos_old[$s])) {
						$s_old = $servicos_old[$s];
						if ($this->config->has("correios_total_{$s_old}")) {
							$data["correios_total_{$s}"] = $this->config->get("correios_total_{$s_old}");
						}
					}
				}
			}
		}

		if (isset($this->request->post['correios_tax_class_id'])) {
			$data['correios_tax_class_id'] = $this->request->post['correios_tax_class_id'];
		} else {
			$data['correios_tax_class_id'] = $this->config->get('correios_tax_class_id');
		}
		if (isset($this->request->post['correios_geo_zone_id'])) {
			$data['correios_geo_zone_id'] = $this->request->post['correios_geo_zone_id'];
		} else {
			$data['correios_geo_zone_id'] = $this->config->get('correios_geo_zone_id');
		}
		if (isset($this->request->post['correios_status'])) {
			$data['correios_status'] = $this->request->post['correios_status'];
		} else {
			$data['correios_status'] = $this->config->get('correios_status');
		}
		if (isset($this->request->post['correios_sort_order'])) {
			$data['correios_sort_order'] = $this->request->post['correios_sort_order'];
		} else {
			$data['correios_sort_order'] = $this->config->get('correios_sort_order');
		}

		$this->load->model('localisation/tax_class');

		$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		if (version_compare(VERSION, '2.2') < 0) {
			$this->response->setOutput($this->load->view('shipping/correios.tpl', $data));
		} else {
			$this->response->setOutput($this->load->view('shipping/correios', $data));
		}
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'shipping/correios')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!preg_match ("/^([0-9]{2})\.?([0-9]{3})-?([0-9]{3})$/", $this->request->post['correios_postcode'])) {
			$this->error['postcode'] = $this->language->get('error_postcode');
		}

		return !$this->error;
	}
}