<?php
class ControllerPaymentPagarMeCheckout extends Controller {
	private $error = array();

	public function index() {
		$data = $this->load->language('payment/pagar_me_checkout');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->document->addScript('view/javascript/pagar_me_checkout/colorpicker/js/colorpicker.js');
		$this->document->addStyle('view/javascript/pagar_me_checkout/colorpicker/css/colorpicker.css');

		if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
			$this->load->model('setting/setting');

			$this->model_setting_setting->editSetting('pagar_me_checkout', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['nome'])) {
			$data['error_nome'] = $this->error['nome'];
		} else {
			$data['error_nome'] = '';
		}

		if (isset($this->error['criptografia'])) {
			$data['error_criptografia'] = $this->error['criptografia'];
		} else {
			$data['error_criptografia'] = '';
		}

		if (isset($this->error['api'])) {
			$data['error_api'] = $this->error['api'];
		} else {
			$data['error_api'] = '';
		}

		if (isset($this->error['payment_methods'])) {
			$data['error_payment_methods'] = $this->error['payment_methods'];
		} else {
			$data['error_payment_methods'] = '';
		}

		if (isset($this->error['card_brands'])) {
			$data['error_card_brands'] = $this->error['card_brands'];
		} else {
			$data['error_card_brands'] = '';
		}

		if (isset($this->error['max_installments'])) {
			$data['error_max_installments'] = $this->error['max_installments'];
		} else {
			$data['error_max_installments'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_payment'),
			'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('payment/pagar_me_checkout', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('payment/pagar_me_checkout', 'token=' . $this->session->data['token'], 'SSL');
		$data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['pagar_me_checkout_nome'])) {
			$data['pagar_me_checkout_nome'] = $this->request->post['pagar_me_checkout_nome'];
		} elseif($this->config->get('pagar_me_checkout_nome')) {
			$data['pagar_me_checkout_nome'] = $this->config->get('pagar_me_checkout_nome');
		} else {
			$data['pagar_me_checkout_nome'] = 'Pagar.me (Cartão de Crédito ou Boleto)';
		}

		if (isset($this->request->post['pagar_me_checkout_criptografia'])) {
			$data['pagar_me_checkout_criptografia'] = $this->request->post['pagar_me_checkout_criptografia'];
		} else {
			$data['pagar_me_checkout_criptografia'] = $this->config->get('pagar_me_checkout_criptografia');
		}

		if (isset($this->request->post['pagar_me_checkout_api'])) {
			$data['pagar_me_checkout_api'] = $this->request->post['pagar_me_checkout_api'];
		} else {
			$data['pagar_me_checkout_api'] = $this->config->get('pagar_me_checkout_api');
		}

		if (isset($this->request->post['pagar_me_checkout_payment_methods'])) {
			$data['pagar_me_checkout_payment_methods'] = $this->request->post['pagar_me_checkout_payment_methods'];
		} elseif($this->config->get('pagar_me_checkout_payment_methods')) {
			$data['pagar_me_checkout_payment_methods'] = $this->config->get('pagar_me_checkout_payment_methods');
		}else{
			$data['pagar_me_checkout_payment_methods'] = array();
		}

		if (isset($this->request->post['pagar_me_checkout_card_brands'])) {
			$data['pagar_me_checkout_card_brands'] = $this->request->post['pagar_me_checkout_card_brands'];
		} elseif($this->config->get('pagar_me_checkout_card_brands')) {
			$data['pagar_me_checkout_card_brands'] = $this->config->get('pagar_me_checkout_card_brands');
		}else{
			$data['pagar_me_checkout_card_brands'] = array();
		}

		if (isset($this->request->post['pagar_me_checkout_max_installments'])) {
			$data['pagar_me_checkout_max_installments'] = $this->request->post['pagar_me_checkout_max_installments'];
		} elseif ($this->config->get('pagar_me_checkout_max_installments')) {
			$data['pagar_me_checkout_max_installments'] = $this->config->get('pagar_me_checkout_max_installments');
		} else {
			$data['pagar_me_checkout_max_installments'] = 12;
		}

		if (isset($this->request->post['pagar_me_checkout_free_installments'])) {
			$data['pagar_me_checkout_free_installments'] = $this->request->post['pagar_me_checkout_free_installments'];
		} elseif ($this->config->get('pagar_me_checkout_free_installments')) {
			$data['pagar_me_checkout_free_installments'] = $this->config->get('pagar_me_checkout_free_installments');
		} else {
			$data['pagar_me_checkout_free_installments'] = 1;
		}

		if (isset($this->request->post['pagar_me_checkout_max_installment_value'])) {
			$data['pagar_me_checkout_max_installment_value'] = $this->request->post['pagar_me_checkout_max_installment_value'];
		} elseif ($this->config->get('pagar_me_checkout_max_installment_value')) {
			$data['pagar_me_checkout_max_installment_value'] = $this->config->get('pagar_me_checkout_max_installment_value');
		} else {
			$data['pagar_me_checkout_max_installment_value'] = '5.00';
		}

		if (isset($this->request->post['pagar_me_checkout_interest_rate'])) {
			$data['pagar_me_checkout_interest_rate'] = $this->request->post['pagar_me_checkout_interest_rate'];
		} elseif ($this->config->get('pagar_me_checkout_interest_rate')) {
			$data['pagar_me_checkout_interest_rate'] = $this->config->get('pagar_me_checkout_interest_rate');
		} else {
			$data['pagar_me_checkout_interest_rate'] = '2.99';
		}

		if (isset($this->request->post['pagar_me_checkout_boleto_discount_percentage'])) {
			$data['pagar_me_checkout_boleto_discount_percentage'] = $this->request->post['pagar_me_checkout_boleto_discount_percentage'];
		} elseif ($this->config->get('pagar_me_checkout_boleto_discount_percentage')) {
			$data['pagar_me_checkout_boleto_discount_percentage'] = $this->config->get('pagar_me_checkout_boleto_discount_percentage');
		} else {
			$data['pagar_me_checkout_boleto_discount_percentage'] = 0;
		}

		if (isset($this->request->post['pagar_me_checkout_ui_color'])) {
			$data['pagar_me_checkout_ui_color'] = $this->request->post['pagar_me_checkout_ui_color'];
		} else {
			$data['pagar_me_checkout_ui_color'] = $this->config->get('pagar_me_checkout_ui_color');
		}

		if (isset($this->request->post['pagar_me_checkout_order_waiting_payment'])) {
			$data['pagar_me_checkout_order_waiting_payment'] = $this->request->post['pagar_me_checkout_order_waiting_payment'];
		} else {
			$data['pagar_me_checkout_order_waiting_payment'] = $this->config->get('pagar_me_checkout_order_waiting_payment');
		}

		if (isset($this->request->post['pagar_me_checkout_order_paid'])) {
			$data['pagar_me_checkout_order_paid'] = $this->request->post['pagar_me_checkout_order_paid'];
		} elseif ($this->config->get('pagar_me_checkout_order_paid')) {
			$data['pagar_me_checkout_order_paid'] = $this->config->get('pagar_me_checkout_order_paid');
		} else {
			$data['pagar_me_checkout_order_paid'] = 15;
		}

		if (isset($this->request->post['pagar_me_checkout_geo_zone_id'])) {
			$data['pagar_me_checkout_geo_zone_id'] = $this->request->post['pagar_me_checkout_geo_zone_id'];
		} else {
			$data['pagar_me_checkout_geo_zone_id'] = $this->config->get('pagar_me_checkout_geo_zone_id');
		}

		if (isset($this->request->post['pagar_me_checkout_status'])) {
			$data['pagar_me_checkout_status'] = $this->request->post['pagar_me_checkout_status'];
		} else {
			$data['pagar_me_checkout_status'] = $this->config->get('pagar_me_checkout_status');
		}

		if (isset($this->request->post['pagar_me_checkout_sort_order'])) {
			$data['pagar_me_checkout_sort_order'] = $this->request->post['pagar_me_checkout_sort_order'];
		} else {
			$data['pagar_me_checkout_sort_order'] = $this->config->get('pagar_me_checkout_sort_order');
		}

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$this->load->model('localisation/geo_zone');
		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('payment/pagar_me_checkout.tpl', $data));
	}

	private function validate() {

		if (!$this->user->hasPermission('modify', 'payment/pagar_me_checkout')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['pagar_me_checkout_nome']) {
			$this->error['nome'] = $this->language->get('error_nome');
		}

		if (!$this->request->post['pagar_me_checkout_criptografia']) {
			$this->error['criptografia'] = $this->language->get('error_criptografia');
		}

		if (!$this->request->post['pagar_me_checkout_api']) {
			$this->error['api'] = $this->language->get('error_api');
		}

		if (!isset($this->request->post['pagar_me_checkout_payment_methods'])) {
			$this->error['payment_methods'] = $this->language->get('error_payment_methods');
		}

		if (!isset($this->request->post['pagar_me_checkout_card_brands'])) {
			$this->error['card_brands'] = $this->language->get('error_card_brands');
		}

		if (!$this->request->post['pagar_me_checkout_max_installments']) {
			$this->error['max_installments'] = $this->language->get('error_max_installments');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	public function install() {
		$this->load->model('payment/pagar_me_checkout');
		$this->model_payment_pagar_me_checkout->install();
	}

	public function uninstall() {
		$this->load->model('payment/pagar_me_checkout');
		$this->model_payment_pagar_me_checkout->uninstall();
	}
}
