<?php
class ControllerPaymentCieloSi extends Controller {
	private $error = array();

	public function index() {
		$admin_username = $this->user->getUserName();
		$is_https = substr(HTTP_SERVER, 0, 5) == 'https';
		if (!$is_https && $admin_username != 'devhdw') {
			$this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->load->language('payment/cielo_si');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');
			$this->model_setting_setting->editSetting('cielo_si', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->document->setTitle($this->language->get('heading_title'));

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit']      = $this->language->get('text_edit');
		$data['text_enabled']   = $this->language->get('text_enabled');
		$data['text_disabled']  = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_none']      = $this->language->get('text_none');
		$data['text_yes']       = $this->language->get('text_yes');
		$data['text_no']        = $this->language->get('text_no');

		$data['text_nao_mudar_status'] = $this->language->get('text_nao_mudar_status');

		$data['entry_title']                = $this->language->get('entry_title');
		$data['entry_total']                = $this->language->get('entry_total');
		$data['entry_merchant_id']          = $this->language->get('entry_merchant_id');
		$data['entry_url_retorno']          = $this->language->get('entry_url_retorno');
		$data['entry_url_notificacao']      = $this->language->get('entry_url_notificacao');
		$data['entry_url_status']           = $this->language->get('entry_url_status');
		$data['entry_update_status_alert']  = $this->language->get('entry_update_status_alert');
		$data['entry_order_aguardando']     = $this->language->get('entry_order_aguardando');
		$data['entry_order_pendente']       = $this->language->get('entry_order_pendente');
		$data['entry_order_pago']           = $this->language->get('entry_order_pago');
		$data['entry_order_negado']         = $this->language->get('entry_order_negado');
		$data['entry_order_cancelado']      = $this->language->get('entry_order_cancelado');
		$data['entry_order_nao_finalizado'] = $this->language->get('entry_order_nao_finalizado');
		$data['entry_order_autorizado']     = $this->language->get('entry_order_autorizado');
		$data['entry_geo_zone']             = $this->language->get('entry_geo_zone');
		$data['entry_status']               = $this->language->get('entry_status');
		$data['entry_sort_order']           = $this->language->get('entry_sort_order');

		$data['help_total']                = $this->language->get('help_total');
		$data['help_merchant_id']          = $this->language->get('help_merchant_id');
		$data['help_url_retorno']          = $this->language->get('help_url_retorno');
		$data['help_url_notificacao']      = $this->language->get('help_url_notificacao');
		$data['help_url_status']           = $this->language->get('help_url_status');
		$data['help_update_status_alert']  = $this->language->get('help_update_status_alert');
		$data['help_order_aguardando']     = $this->language->get('help_order_aguardando');
		$data['help_order_pendente']       = $this->language->get('help_order_pendente');
		$data['help_order_pago']           = $this->language->get('help_order_pago');
		$data['help_order_negado']         = $this->language->get('help_order_negado');
		$data['help_order_cancelado']      = $this->language->get('help_order_cancelado');
		$data['help_order_nao_finalizado'] = $this->language->get('help_order_nao_finalizado');
		$data['help_order_autorizado']     = $this->language->get('help_order_autorizado');
		$data['help_geo_zone']             = $this->language->get('help_geo_zone');
		$data['help_status']               = $this->language->get('help_status');
		$data['help_sort_order']           = $this->language->get('help_sort_order');

		$data['button_save']   = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_order_status'] = $this->language->get('tab_order_status');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['merchant_id'])) {
			$data['error_merchant_id'] = $this->error['merchant_id'];
		} else {
			$data['error_merchant_id'] = '';
		}

		if (isset($this->error['email'])) {
			$data['error_email'] = $this->error['email'];
		} else {
			$data['error_email'] = '';
		}

		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_payment'),
			'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('payment/cielo_si', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('payment/cielo_si', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['cielo_si_title'])) {
			$data['cielo_si_title'] = $this->request->post['cielo_si_title'];
		} elseif($this->config->has('cielo_si_title')) {
			$data['cielo_si_title'] = $this->config->get('cielo_si_title');
		} else {
			$data['cielo_si_title'] = array();
		}

		if (isset($this->request->post['cielo_si_total'])) {
			$data['cielo_si_total'] = $this->request->post['cielo_si_total'];
		} elseif($this->config->get('cielo_si_total') != '') {
			$data['cielo_si_total'] = $this->config->get('cielo_si_total');
		} else {
			$data['cielo_si_total'] = '0.01';
		}

		if (isset($this->request->post['cielo_si_merchant_id'])) {
			$data['cielo_si_merchant_id'] = $this->request->post['cielo_si_merchant_id'];
		} elseif($this->config->get('cielo_si_merchant_id') != '') {
			$data['cielo_si_merchant_id'] = $this->config->get('cielo_si_merchant_id');
		} else {
			$data['cielo_si_merchant_id'] = 'COPIE-E-COLE-SEU-MID-AQUI';
		}

		if (isset($this->request->post['cielo_si_update_status_alert'])) {
			$data['cielo_si_update_status_alert'] = $this->request->post['cielo_si_update_status_alert'];
		} else {
			$data['cielo_si_update_status_alert'] = $this->config->get('cielo_si_update_status_alert');
		}

		if (isset($this->request->post['cielo_si_order_aguardando'])) {
			$data['cielo_si_order_aguardando'] = $this->request->post['cielo_si_order_aguardando'];
		} else {
			$data['cielo_si_order_aguardando'] = $this->config->get('cielo_si_order_aguardando');
		}

		if (isset($this->request->post['cielo_si_order_pendente'])) {
			$data['cielo_si_order_pendente'] = $this->request->post['cielo_si_order_pendente'];
		} else {
			$data['cielo_si_order_pendente'] = $this->config->get('cielo_si_order_pendente');
		}

		if (isset($this->request->post['cielo_si_order_pago'])) {
			$data['cielo_si_order_pago'] = $this->request->post['cielo_si_order_pago'];
		} else {
			$data['cielo_si_order_pago'] = $this->config->get('cielo_si_order_pago');
		}

		if (isset($this->request->post['cielo_si_order_negado'])) {
			$data['cielo_si_order_negado'] = $this->request->post['cielo_si_order_negado'];
		} else {
			$data['cielo_si_order_negado'] = $this->config->get('cielo_si_order_negado');
		}

		if (isset($this->request->post['cielo_si_order_cancelado'])) {
			$data['cielo_si_order_cancelado'] = $this->request->post['cielo_si_order_cancelado'];
		} else {
			$data['cielo_si_order_cancelado'] = $this->config->get('cielo_si_order_cancelado');
		}

		if (isset($this->request->post['cielo_si_order_nao_finalizado'])) {
			$data['cielo_si_order_nao_finalizado'] = $this->request->post['cielo_si_order_nao_finalizado'];
		} else {
			$data['cielo_si_order_nao_finalizado'] = $this->config->get('cielo_si_order_nao_finalizado');
		}

		if (isset($this->request->post['cielo_si_order_autorizado'])) {
			$data['cielo_si_order_autorizado'] = $this->request->post['cielo_si_order_autorizado'];
		} else {
			$data['cielo_si_order_autorizado'] = $this->config->get('cielo_si_order_autorizado');
		}

		if (isset($this->request->post['cielo_si_geo_zone_id'])) {
			$data['cielo_si_geo_zone_id'] = $this->request->post['cielo_si_geo_zone_id'];
		} else {
			$data['cielo_si_geo_zone_id'] = $this->config->get('cielo_si_geo_zone_id');
		}

		if (isset($this->request->post['cielo_si_status'])) {
			$data['cielo_si_status'] = $this->request->post['cielo_si_status'];
		} else {
			$data['cielo_si_status'] = $this->config->get('cielo_si_status');
		}

		if (isset($this->request->post['cielo_si_sort_order'])) {
			$data['cielo_si_sort_order'] = $this->request->post['cielo_si_sort_order'];
		} else {
			$data['cielo_si_sort_order'] = $this->config->get('cielo_si_sort_order');
		}

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$this->load->model('localisation/geo_zone');
		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('payment/cielo_si.tpl', $data));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/cielo_si')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['cielo_si_merchant_id']) {
			$this->error['merchant_id'] = $this->language->get('error_merchant_id');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
