<?php
require_once (DIR_SYSTEM . "library/Cielo/config.php");

class ControllerPaymentCielo extends Controller {
 	private $error = array();

	public function index() {
		$admin_username = $this->user->getUserName();
		$is_https = substr(HTTP_SERVER, 0, 5) == 'https';
		if (!$is_https && $admin_username != 'devhdw') {
			$this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->load->language('payment/cielo');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');
			$this->model_setting_setting->editSetting('cielo', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->document->setTitle($this->language->get('heading_title'));

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit']      = $this->language->get('text_edit');
		$data['text_enabled']   = $this->language->get('text_enabled');
		$data['text_disabled']  = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_none']      = $this->language->get('text_none');
		$data['text_yes']       = $this->language->get('text_yes');
		$data['text_no']        = $this->language->get('text_no');

		$data['text_nao_modificar']   = $this->language->get('text_nao_modificar');
		$data['text_ambiente_testes'] = $this->language->get('text_ambiente_testes');
		$data['text_ambiente_venda']  = $this->language->get('text_ambiente_venda');

		$data['cartoes'] = $GLOBALS['CIELO_BANDEIRAS_DISPONIVEIS'];
		$data['cartoes_debito'] = $GLOBALS['CIELO_BANDEIRAS_DEBITO'];

		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_status'] = $this->language->get('tab_status');
		$data['tab_cards'] = $this->language->get('tab_cards');
		$data['title_tab_general'] = $this->language->get('title_tab_general');

		$data['tab_names'] = array();
		$data['title_names'] = array();

		foreach ($GLOBALS['CIELO_BANDEIRAS_DISPONIVEIS'] as $bandeira) {
			$data['tab_names'][$bandeira] = $this->language->get("tab_{$bandeira}");
			$data['title_names'][$bandeira] = $this->language->get("title_tab_{$bandeira}");
			$data["entry_ativar_{$bandeira}"] = $this->language->get("entry_ativar_{$bandeira}");
			$data["help_ativar_{$bandeira}"] = $this->language->get("help_ativar_{$bandeira}");
		}

		$data['entry_title']               = $this->language->get('entry_title');
		$data['entry_total']               = $this->language->get('entry_total');
		$data['entry_afiliacao']           = $this->language->get('entry_afiliacao');
		$data['entry_chave']               = $this->language->get('entry_chave');
		$data['entry_ambiente']            = $this->language->get('entry_ambiente');
		$data['entry_status_pendente']     = $this->language->get('entry_status_pendente');
		$data['entry_status_aprovada']     = $this->language->get('entry_status_aprovada');
		$data['entry_status_nao_aprovada'] = $this->language->get('entry_status_nao_aprovada');
		$data['entry_update_status_alert'] = $this->language->get('entry_update_status_alert');
		$data['entry_geo_zone']            = $this->language->get('entry_geo_zone');
		$data['entry_status']              = $this->language->get('entry_status');
		$data['entry_sort_order']          = $this->language->get('entry_sort_order');

		$data['entry_valor_minimo']        = $this->language->get('entry_valor_minimo');
		$data['entry_desconto']            = $this->language->get('entry_desconto');
		$data['entry_parcelamento']        = $this->language->get('entry_parcelamento');
		$data['entry_max_parcelas']        = $this->language->get('entry_max_parcelas');
		$data['entry_parcelas_sem_juros']  = $this->language->get('entry_parcelas_sem_juros');
		$data['entry_parcelas_juros_loja'] = $this->language->get('entry_parcelas_juros_loja');
		$data['entry_parcela_minima']      = $this->language->get('entry_parcela_minima');
		$data['entry_juros']               = $this->language->get('entry_juros');
		$data['entry_calculo_juros']       = $this->language->get('entry_calculo_juros');
		$data['entry_captura_automatica']  = $this->language->get('entry_captura_automatica');
		$data['entry_tipo_autorizacao']    = $this->language->get('entry_tipo_autorizacao');

		$data['help_total']                = $this->language->get('help_total');
		$data['help_afiliacao']            = $this->language->get('help_afiliacao');
		$data['help_chave']                = $this->language->get('help_chave');
		$data['help_ambiente']             = $this->language->get('help_ambiente');
		$data['help_status_pendente']      = $this->language->get('help_status_pendente');
		$data['help_status_aprovada']      = $this->language->get('help_status_aprovada');
		$data['help_status_nao_aprovada']  = $this->language->get('help_status_nao_aprovada');
		$data['help_update_status_alert']  = $this->language->get('help_update_status_alert');
		$data['help_valor_minimo']         = $this->language->get('help_valor_minimo');
		$data['help_desconto']             = $this->language->get('help_desconto');
		$data['help_parcela_minima']       = $this->language->get('help_parcela_minima');
		$data['help_max_parcelas']         = $this->language->get('help_max_parcelas');
		$data['help_parcelas_juros_loja']  = $this->language->get('help_parcelas_juros_loja');
		$data['help_juros']                = $this->language->get('help_juros');
		$data['help_calculo_juros']        = $this->language->get('help_calculo_juros');
		$data['help_captura_automatica']   = $this->language->get('help_captura_automatica');
		$data['help_tipo_autorizacao']     = sprintf($this->language->get('help_tipo_autorizacao'), $GLOBALS['CIELO_VALORES_PADROES']['tipo_autorizacao'], $GLOBALS['CIELO_VALORES_PADROES']['tipo_autorizacao_debito']);

		$data['text_calculo_juros_1']      = $this->language->get('text_calculo_juros_1');
		$data['text_calculo_juros_2']      = $this->language->get('text_calculo_juros_2');
		$data['text_calculo_juros_3']      = $this->language->get('text_calculo_juros_3');

		foreach($GLOBALS['CIELO_TIPOS_AUTORIZACAO'] as $tipo_autorizacao){
			$data["text_tipo_autorizacao_{$tipo_autorizacao}"] = $this->language->get("text_tipo_autorizacao_{$tipo_autorizacao}");
		}

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['total'])) {
			$data['error_total'] = $this->error['total'];
		} else {
			$data['error_total'] = '';
		}

		if (isset($this->error['afiliacao'])) {
			$data['error_afiliacao'] = $this->error['afiliacao'];
		} else {
			$data['error_afiliacao'] = '';
		}

		if (isset($this->error['chave'])) {
			$data['error_chave'] = $this->error['chave'];
		} else {
			$data['error_chave'] = '';
		}

		if (isset($this->error['error_cartoes'])) {
			$data['error_cartoes'] = $this->error['error_cartoes'];
		} else {
			$data['error_cartoes'] = '';
		}

		foreach($GLOBALS['CIELO_BANDEIRAS_DISPONIVEIS'] as $cartao){
			if (isset($this->error["error_{$cartao}"])) {
				$data["error_{$cartao}"] = $this->error["error_{$cartao}"];
			} else {
				$data["error_{$cartao}"] = FALSE;
			}

			if (isset($this->error["{$cartao}_valor_minimo"])) {
				$data["error_{$cartao}_valor_minimo"] = $this->error["{$cartao}_valor_minimo"];
			} else {
				$data["error_{$cartao}_valor_minimo"] = '';
			}

			if (isset($this->error["{$cartao}_desconto"])) {
				$data["error_{$cartao}_desconto"] = $this->error["{$cartao}_desconto"];
			} else {
				$data["error_{$cartao}_desconto"] = '';
			}

			if (isset($this->error["{$cartao}_max_parcelas"])) {
				$data["error_{$cartao}_max_parcelas"] = $this->error["{$cartao}_max_parcelas"];
			} else {
				$data["error_{$cartao}_max_parcelas"] = '';
			}

			if (isset($this->error["{$cartao}_parcelas_sem_juros"])) {
				$data["error_{$cartao}_parcelas_sem_juros"] = $this->error["{$cartao}_parcelas_sem_juros"];
			} else {
				$data["error_{$cartao}_parcelas_sem_juros"] = '';
			}

			if (isset($this->error["{$cartao}_parcelas_juros_loja"])) {
				$data["error_{$cartao}_parcelas_juros_loja"] = $this->error["{$cartao}_parcelas_juros_loja"];
			} else {
				$data["error_{$cartao}_parcelas_juros_loja"] = '';
			}

			if (isset($this->error["{$cartao}_parcela_minima"])) {
				$data["error_{$cartao}_parcela_minima"] = $this->error["{$cartao}_parcela_minima"];
			} else {
				$data["error_{$cartao}_parcela_minima"] = '';
			}

			if (isset($this->error["{$cartao}_juros"])) {
				$data["error_{$cartao}_juros"] = $this->error["{$cartao}_juros"];
			} else {
				$data["error_{$cartao}_juros"] = '';
			}
		}

		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_payment'),
			'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('payment/cielo', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('payment/cielo', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['cielo_title'])) {
			$data['cielo_title'] = $this->request->post['cielo_title'];
		} elseif($this->config->has('cielo_title')) {
			$data['cielo_title'] = $this->config->get('cielo_title');
		} else {
			$data['cielo_title'] = array();
		}

		if (isset($this->request->post['cielo_total'])) {
			$data['cielo_total'] = $this->request->post['cielo_total'];
		} else {
			$data['cielo_total'] = $this->config->get('cielo_total');
			// valor padrao
			if($data['cielo_total'] == ''){
				$data['cielo_total'] = $GLOBALS['CIELO_VALORES_PADROES']['total'];
			}
		}

		if (isset($this->request->post['cielo_afiliacao'])) {
			$data['cielo_afiliacao'] = $this->request->post['cielo_afiliacao'];
		} else {
			$data['cielo_afiliacao'] = $this->config->get('cielo_afiliacao');
		}

		if (isset($this->request->post['cielo_chave'])) {
			$data['cielo_chave'] = $this->request->post['cielo_chave'];
		} else {
			$data['cielo_chave'] = $this->config->get('cielo_chave');
		}

		if (isset($this->request->post['cielo_ambiente'])) {
			$data['cielo_ambiente'] = $this->request->post['cielo_ambiente'];
		} else {
			$data['cielo_ambiente'] = $this->config->get('cielo_ambiente');
		}

		if (isset($this->request->post['cielo_status_pendente'])) {
			$data['cielo_status_pendente'] = $this->request->post['cielo_status_pendente'];
		} else {
			$data['cielo_status_pendente'] = $this->config->get('cielo_status_pendente');
			// valor padrao
			if($data['cielo_status_pendente'] == ''){
				$data['cielo_status_pendente'] = $GLOBALS['CIELO_VALORES_PADROES']['status_pendente'];
			}
		}

		if (isset($this->request->post['cielo_status_aprovada'])) {
			$data['cielo_status_aprovada'] = $this->request->post['cielo_status_aprovada'];
		} else {
			$data['cielo_status_aprovada'] = $this->config->get('cielo_status_aprovada');
			// valor padrao
			if($data['cielo_status_aprovada'] == ''){
				$data['cielo_status_aprovada'] = $GLOBALS['CIELO_VALORES_PADROES']['status_aprovada'];
			}
		}

		if (isset($this->request->post['cielo_status_nao_aprovada'])) {
			$data['cielo_status_nao_aprovada'] = $this->request->post['cielo_status_nao_aprovada'];
		} else {
			$data['cielo_status_nao_aprovada'] = $this->config->get('cielo_status_nao_aprovada');
			// valor padrao
			if($data['cielo_status_nao_aprovada'] == ''){
				$data['cielo_status_nao_aprovada'] = $GLOBALS['CIELO_VALORES_PADROES']['status_nao_aprovada'];
			}
		}

		if (isset($this->request->post['cielo_update_status_alert'])) {
			$data['cielo_update_status_alert'] = $this->request->post['cielo_update_status_alert'];
		} else {
			$data['cielo_update_status_alert'] = $this->config->get('cielo_update_status_alert');
		}

		if (isset($this->request->post['cielo_geo_zone_id'])) {
			$data['cielo_geo_zone_id'] = $this->request->post['cielo_geo_zone_id'];
		} else {
			$data['cielo_geo_zone_id'] = $this->config->get('cielo_geo_zone_id');
		}

		if (isset($this->request->post['cielo_status'])) {
			$data['cielo_status'] = $this->request->post['cielo_status'];
		} else {
			$data['cielo_status'] = $this->config->get('cielo_status');
		}

		if (isset($this->request->post['cielo_sort_order'])) {
			$data['cielo_sort_order'] = $this->request->post['cielo_sort_order'];
		} else {
			$data['cielo_sort_order'] = $this->config->get('cielo_sort_order');
		}

		foreach($GLOBALS['CIELO_BANDEIRAS_DISPONIVEIS'] as $cartao){
			if (isset($this->request->post["cielo_{$cartao}_ativar"])) {
				$data["cielo_{$cartao}_ativar"] = $this->request->post["cielo_{$cartao}_ativar"];
			} else {
				$data["cielo_{$cartao}_ativar"] = $this->config->get("cielo_{$cartao}_ativar");
			}

			if (isset($this->request->post["cielo_{$cartao}_valor_minimo"])) {
				$data["cielo_{$cartao}_valor_minimo"] = $this->request->post["cielo_{$cartao}_valor_minimo"];
			} else {
				$data["cielo_{$cartao}_valor_minimo"] = $this->config->get("cielo_{$cartao}_valor_minimo");
				// valor padrao
				if($data["cielo_{$cartao}_valor_minimo"] == ''){
					$data["cielo_{$cartao}_valor_minimo"] = $GLOBALS['CIELO_VALORES_PADROES']['valor_minimo'];
				}
			}

			if (isset($this->request->post["cielo_{$cartao}_desconto"])) {
				$data["cielo_{$cartao}_desconto"] = $this->request->post["cielo_{$cartao}_desconto"];
			} else {
				$data["cielo_{$cartao}_desconto"] = $this->config->get("cielo_{$cartao}_desconto");
				// valor padrao
				if($data["cielo_{$cartao}_desconto"] == ''){
					$data["cielo_{$cartao}_desconto"] = $GLOBALS['CIELO_VALORES_PADROES']['desconto'];
				}
			}

			if (isset($this->request->post["cielo_{$cartao}_parcelamento"])) {
				$data["cielo_{$cartao}_parcelamento"] = $this->request->post["cielo_{$cartao}_parcelamento"];
			} else {
				$data["cielo_{$cartao}_parcelamento"] = $this->config->get("cielo_{$cartao}_parcelamento");
			}

			if (isset($this->request->post["cielo_{$cartao}_max_parcelas"])) {
				$data["cielo_{$cartao}_max_parcelas"] = $this->request->post["cielo_{$cartao}_max_parcelas"];
			} else {
				$data["cielo_{$cartao}_max_parcelas"] = $this->config->get("cielo_{$cartao}_max_parcelas");
			}

			if (isset($this->request->post["cielo_{$cartao}_parcelas_sem_juros"])) {
				$data["cielo_{$cartao}_parcelas_sem_juros"] = $this->request->post["cielo_{$cartao}_parcelas_sem_juros"];
			} else {
				$data["cielo_{$cartao}_parcelas_sem_juros"] = $this->config->get("cielo_{$cartao}_parcelas_sem_juros");
			}

			if (isset($this->request->post["cielo_{$cartao}_parcelas_juros_loja"])) {
				$data["cielo_{$cartao}_parcelas_juros_loja"] = $this->request->post["cielo_{$cartao}_parcelas_juros_loja"];
			} else {
				$data["cielo_{$cartao}_parcelas_juros_loja"] = $this->config->get("cielo_{$cartao}_parcelas_juros_loja");
			}

			if (isset($this->request->post["cielo_{$cartao}_parcela_minima"])) {
				$data["cielo_{$cartao}_parcela_minima"] = $this->request->post["cielo_{$cartao}_parcela_minima"];
			} else {
				$data["cielo_{$cartao}_parcela_minima"] = $this->config->get("cielo_{$cartao}_parcela_minima");
				// valor padrao
				if($data["cielo_{$cartao}_parcela_minima"] == ''){
					$data["cielo_{$cartao}_parcela_minima"] = $GLOBALS['CIELO_VALORES_PADROES']['parcela_minima'];
				}
			}

			if (isset($this->request->post["cielo_{$cartao}_juros"])) {
				$data["cielo_{$cartao}_juros"] = $this->request->post["cielo_{$cartao}_juros"];
			} else {
				$data["cielo_{$cartao}_juros"] = $this->config->get("cielo_{$cartao}_juros");
				// valor padrao
				if($data["cielo_{$cartao}_juros"] == ''){
					$data["cielo_{$cartao}_juros"] = $GLOBALS['CIELO_VALORES_PADROES']['taxa_juros'];
				}
			}

			if (isset($this->request->post["cielo_{$cartao}_calculo_juros"])) {
				$data["cielo_{$cartao}_calculo_juros"] = $this->request->post["cielo_{$cartao}_calculo_juros"];
			} else {
				$data["cielo_{$cartao}_calculo_juros"] = $this->config->get("cielo_{$cartao}_calculo_juros");
			}

			if (isset($this->request->post["cielo_{$cartao}_captura_automatica"])) {
				$data["cielo_{$cartao}_captura_automatica"] = $this->request->post["cielo_{$cartao}_captura_automatica"];
			} else {
				$data["cielo_{$cartao}_captura_automatica"] = $this->config->get("cielo_{$cartao}_captura_automatica");
			}

			if (isset($this->request->post["cielo_{$cartao}_tipo_autorizacao"])) {
				$data["cielo_{$cartao}_tipo_autorizacao"] = $this->request->post["cielo_{$cartao}_tipo_autorizacao"];
			} else {
				$data["cielo_{$cartao}_tipo_autorizacao"] = $this->config->get("cielo_{$cartao}_tipo_autorizacao");
				// valor padrao
				if($data["cielo_{$cartao}_tipo_autorizacao"] == ''){
					if( array_key_exists($cartao, $GLOBALS['CIELO_BANDEIRAS_DEBITO']) ){
						$data["cielo_{$cartao}_tipo_autorizacao"] = $GLOBALS['CIELO_VALORES_PADROES']['tipo_autorizacao_debito'];
					}else{
						$data["cielo_{$cartao}_tipo_autorizacao"] = $GLOBALS['CIELO_VALORES_PADROES']['tipo_autorizacao'];
					}
				}
			}
		}

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$this->load->model('localisation/geo_zone');
		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('payment/cielo.tpl', $data));
	}

	private function validate() {

		// checa permissao
		if (!$this->user->hasPermission('modify', 'payment/cielo')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		// valida configs gerais
		if (!is_numeric($this->request->post['cielo_total'])) {
			$this->error['total'] = $this->language->get('error_total');
		}

		if (!$this->request->post['cielo_afiliacao']) {
			$this->error['afiliacao'] = $this->language->get('error_afiliacao');
		}

		if (!$this->request->post['cielo_chave']) {
			$this->error['chave'] = $this->language->get('error_chave');
		}

		// valida configs dos cartoes
		foreach($GLOBALS['CIELO_BANDEIRAS_DISPONIVEIS'] as $cartao){
			// se o cartao estiver habilitado precisamos validar os outros campos
			if ($this->request->post["cielo_{$cartao}_ativar"] == 1) {
				if ( !is_numeric($this->request->post["cielo_{$cartao}_valor_minimo"]) ) {
					$this->error["{$cartao}_valor_minimo"] = $this->language->get('error_valor_minimo');
					$this->error["error_{$cartao}"] = TRUE;
				}

				if ( !is_numeric($this->request->post["cielo_{$cartao}_desconto"]) ) {
					$this->error["{$cartao}_desconto"] = $this->language->get('error_desconto');
					$this->error["error_{$cartao}"] = TRUE;
				}

				// se o parcelamento estiver habilitado precisamos validar os outros campos
				if ($this->request->post["cielo_{$cartao}_parcelamento"] == 1) {
					if (
						!is_numeric($this->request->post["cielo_{$cartao}_max_parcelas"]) OR
						$this->request->post["cielo_{$cartao}_max_parcelas"] < $GLOBALS['CIELO_MINIMO_PARCELAS'] OR
						$this->request->post["cielo_{$cartao}_max_parcelas"] > $GLOBALS['CIELO_MAXIMO_PARCELAS']
					) {
						$this->error["{$cartao}_max_parcelas"] = sprintf($this->language->get('error_max_parcelas'), $GLOBALS['CIELO_MINIMO_PARCELAS'], $GLOBALS['CIELO_MAXIMO_PARCELAS']);
						$this->error["error_{$cartao}"] = TRUE;
					}

					if (
						!is_numeric($this->request->post["cielo_{$cartao}_parcelas_sem_juros"]) OR
						$this->request->post["cielo_{$cartao}_parcelas_sem_juros"] < 0 OR
						$this->request->post["cielo_{$cartao}_parcelas_sem_juros"] > $this->request->post["cielo_{$cartao}_max_parcelas"]
					) {
						$this->error["{$cartao}_parcelas_sem_juros"] = $this->language->get('error_parcelas_sem_juros');
						$this->error["error_{$cartao}"] = TRUE;
					}

					if (
						!is_numeric($this->request->post["cielo_{$cartao}_parcelas_juros_loja"]) OR
						$this->request->post["cielo_{$cartao}_parcelas_juros_loja"] < 0 OR
						$this->request->post["cielo_{$cartao}_parcelas_juros_loja"] > $this->request->post["cielo_{$cartao}_max_parcelas"]
					) {
						$this->error["{$cartao}_parcelas_juros_loja"] = $this->language->get('error_parcelas_juros_loja');
						$this->error["error_{$cartao}"] = TRUE;
					}

					if (
						!is_numeric($this->request->post["cielo_{$cartao}_parcela_minima"]) OR
						$this->request->post["cielo_{$cartao}_parcela_minima"] < $GLOBALS['CIELO_PARCELA_MINIMA']
					) {
						$this->error["{$cartao}_parcela_minima"] = sprintf($this->language->get('error_parcela_minima'), $GLOBALS['CIELO_PARCELA_MINIMA']);
						$this->error["error_{$cartao}"] = TRUE;
					}

					if (
						!is_numeric($this->request->post["cielo_{$cartao}_juros"]) OR
						$this->request->post["cielo_{$cartao}_juros"] < 0
					) {
						$this->error["{$cartao}_juros"] = $this->language->get('error_juros');
						$this->error["error_{$cartao}"] = TRUE;
					}

				}
			}

			if(isset($this->error["error_{$cartao}"])){
				if($this->error["error_{$cartao}"] === TRUE){
					$this->error['error_cartoes'] = $this->language->get('error_cartoes');
				}
			}
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}



	public function capturar() {

		$json = array();
		$isAjax = ((isset($_SERVER['HTTP_X_REQUESTED_WITH']) ? strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) : '') == 'xmlhttprequest');

		$tid = isset($this->request->get["tid"]) ? trim($this->request->get["tid"]) : '';
		$order_id = isset($this->request->get["oid"]) ? trim($this->request->get["oid"]) : '';

		// valida o tid recebido
		if($tid != ''){

			$this->load->model('payment/cielo');
			$transacao = $this->model_payment_cielo->buscarTransacaoPorTID($tid);

			// valida o tid retornado
			if( isset($transacao['valor']) ){

				$valor = number_format($transacao['valor'],2,'','');
				$status = $transacao['status'];
				$capturar = $transacao['capturar'];
				$order_status_id = $transacao['order_status_id'];

				// faz a captura na cielo
				$resposta = $this->model_payment_cielo->requisicaoCaptura($tid, $valor);
				$resposta = false;
				if($resposta === FALSE){
					$resposta = $this->model_payment_cielo->requisicaoConsulta($tid);
				}

				if($resposta !== FALSE){
					// processa a resposta da captura
					$cond = $this->model_payment_cielo->processarRespostaConsulta($tid, $status, $capturar, $order_status_id, $resposta);

					if($cond !== FALSE){

						$new_status = $resposta['status'];

						if($new_status == '6'){
							$json['success'] = 1;
						}else{
							$json['error'] = 1;
							//echo('Nao foi possivel finalizar a captura.');
						}

					}else{
						$json['error'] = 2;
						//echo('Nao foi possivel processar a resposta da consulta na Cielo.');
					}

				}else{
					$json['error'] = 3;
					//echo('Nao foi possivel fazer a consulta na Cielo.');
				}

			}else{
				$json['error'] = 4;
				//echo('TID nao encontrado!');
			}

		}else{
			$json['error'] = 5;
			//echo('TID invalido!');
		}

		if($isAjax){
			echo json_encode($json);
		}else{
			if($order_id != ''){
				if(isset($json['error'])){
					$this->response->redirect($this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . $order_id . '&ce='. $json['error'], 'SSL'));
				}else{
					$this->response->redirect($this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . $order_id . '&cs=1', 'SSL'));
				}
			}else{
				if(isset($json['error'])){
					$this->response->redirect($this->url->link('common/home', 'token=' . $this->session->data['token'] . '&ce='. $json['error'], 'SSL'));
				}else{
					$this->response->redirect($this->url->link('common/home', 'token=' . $this->session->data['token'] . '&cs=1', 'SSL'));
				}
			}
		}

	} // capturar



	public function install() {

		$query = $this->db->query("
			CREATE TABLE IF NOT EXISTS `". DB_PREFIX ."cielo_transacoes` (
				`tid` varchar(40) COLLATE utf8_bin NOT NULL,
				`code` char(32) COLLATE utf8_bin NOT NULL,
				`order_id` int(11) NOT NULL,
				`valor` decimal(12,2) NOT NULL,
				`datahora` datetime NOT NULL,
				`bandeira` varchar(20) COLLATE utf8_bin NOT NULL,
				`produto` char(1) COLLATE utf8_bin NOT NULL,
				`parcelas` tinyint(2) NOT NULL,
				`autorizar` tinyint(1) NOT NULL,
				`capturar` tinyint(1) NOT NULL,
				`status` tinyint(2) NOT NULL DEFAULT '0',
				`finalizada` tinyint(1) NOT NULL DEFAULT '0',
				PRIMARY KEY (`tid`),
				KEY `code` (`code`),
				KEY `order_id` (`order_id`,`finalizada`)
			) ENGINE=MyISAM;
		");

		$query = $this->db->query("
			CREATE TABLE IF NOT EXISTS `". DB_PREFIX ."cielo_consultas` (
				`tid` varchar(40) COLLATE utf8_bin NOT NULL,
				`status` tinyint(2) NOT NULL,
				`datahora` datetime NOT NULL,
				KEY `tid` (`tid`)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
		");

	}



	public function uninstall() {
		// nao exclui os campos para nao perder os dados caso ja tenha sido instalado antes
		$this->load->model('setting/setting');
		$this->model_setting_setting->editSetting('cielo', array('cielo_status' => '0'));
	}

}
