<?php
class ControllerPaymentBndes extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('payment/bndes');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('bndes', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');

		$data['entry_title'] = $this->language->get('entry_title');
		$data['entry_pre_instructions'] = $this->language->get('entry_pre_instructions');
		$data['entry_post_instructions'] = $this->language->get('entry_post_instructions');
		$data['entry_total'] = $this->language->get('entry_total');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['help_total'] = $this->language->get('help_total');
		$data['help_pre_instructions'] = $this->language->get('help_pre_instructions');
		$data['help_post_instructions'] = $this->language->get('help_post_instructions');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_payment'),
			'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('payment/bndes', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('payment/bndes', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['bndes_title'])) {
			$data['bndes_title'] = $this->request->post['bndes_title'];
		} elseif($this->config->has('bndes_title')) {
			$data['bndes_title'] = $this->config->get('bndes_title');
		} else {
			$data['bndes_title'] = array();
		}

		if (isset($this->request->post['bndes_pre_instructions'])) {
			$data['bndes_pre_instructions'] = $this->request->post['bndes_pre_instructions'];
		} elseif($this->config->has('bndes_pre_instructions')) {
			$data['bndes_pre_instructions'] = $this->config->get('bndes_pre_instructions');
		} else {
			$data['bndes_pre_instructions'] = array();
		}

		if (isset($this->request->post['bndes_post_instructions'])) {
			$data['bndes_post_instructions'] = $this->request->post['bndes_post_instructions'];
		} elseif($this->config->has('bndes_post_instructions')) {
			$data['bndes_post_instructions'] = $this->config->get('bndes_post_instructions');
		} else {
			$data['bndes_post_instructions'] = array();
		}

		if (isset($this->request->post['bndes_total'])) {
			$data['bndes_total'] = $this->request->post['bndes_total'];
		} elseif ($this->config->has('bndes_total')) {
			$data['bndes_total'] = $this->config->get('bndes_total');
		} else {
			$data['bndes_total'] = '0.01';
		}

		if (isset($this->request->post['bndes_order_status_id'])) {
			$data['bndes_order_status_id'] = $this->request->post['bndes_order_status_id'];
		} else {
			$data['bndes_order_status_id'] = $this->config->get('bndes_order_status_id');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['bndes_geo_zone_id'])) {
			$data['bndes_geo_zone_id'] = $this->request->post['bndes_geo_zone_id'];
		} else {
			$data['bndes_geo_zone_id'] = $this->config->get('bndes_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['bndes_status'])) {
			$data['bndes_status'] = $this->request->post['bndes_status'];
		} else {
			$data['bndes_status'] = $this->config->get('bndes_status');
		}

		if (isset($this->request->post['bndes_sort_order'])) {
			$data['bndes_sort_order'] = $this->request->post['bndes_sort_order'];
		} else {
			$data['bndes_sort_order'] = $this->config->get('bndes_sort_order');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('payment/bndes.tpl', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'payment/bndes')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}