<?php
class ControllerPaymentBcash extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('payment/bcash');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('bcash', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_none'] = $this->language->get('text_none');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');

		$data['entry_title'] = $this->language->get('entry_title');
		$data['entry_total'] = $this->language->get('entry_total');
		$data['entry_token'] = $this->language->get('entry_token');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_posfixo'] = $this->language->get('entry_posfixo');
		$data['entry_hash'] = $this->language->get('entry_hash');
		$data['entry_order_aguardando'] = $this->language->get('entry_order_aguardando');
		$data['entry_order_andamento'] = $this->language->get('entry_order_andamento');
		$data['entry_order_aprovada'] = $this->language->get('entry_order_aprovada');
		$data['entry_order_concluida'] = $this->language->get('entry_order_concluida');
		$data['entry_order_cancelada'] = $this->language->get('entry_order_cancelada');
		$data['entry_order_disputa'] = $this->language->get('entry_order_disputa');
		$data['entry_order_chargeback'] = $this->language->get('entry_order_chargeback');
		$data['entry_order_devolvida'] = $this->language->get('entry_order_devolvida');
		$data['entry_update_status_alert'] = $this->language->get('entry_update_status_alert');
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['help_total'] = $this->language->get('help_total');
		$data['help_token'] = $this->language->get('help_token');
		$data['help_email'] = $this->language->get('help_email');
		$data['help_posfixo'] = $this->language->get('help_posfixo');
		$data['help_hash'] = $this->language->get('help_hash');
		$data['help_order_aguardando'] = $this->language->get('help_order_aguardando');
		$data['help_order_andamento'] = $this->language->get('help_order_andamento');
		$data['help_order_aprovada'] = $this->language->get('help_order_aprovada');
		$data['help_order_concluida'] = $this->language->get('help_order_concluida');
		$data['help_order_cancelada'] = $this->language->get('help_order_cancelada');
		$data['help_order_disputa'] = $this->language->get('help_order_disputa');
		$data['help_order_chargeback'] = $this->language->get('help_order_chargeback');
		$data['help_order_devolvida'] = $this->language->get('help_order_devolvida');
		$data['help_update_status_alert'] = $this->language->get('help_update_status_alert');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_order_status'] = $this->language->get('tab_order_status');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['token'])) {
			$data['error_token'] = $this->error['token'];
		} else {
			$data['error_token'] = '';
		}

		if (isset($this->error['email'])) {
			$data['error_email'] = $this->error['email'];
		} else {
			$data['error_email'] = '';
		}

		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_payment'),
			'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('payment/bcash', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('payment/bcash', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['bcash_title'])) {
			$data['bcash_title'] = $this->request->post['bcash_title'];
		} elseif($this->config->has('bcash_title')) {
			$data['bcash_title'] = $this->config->get('bcash_title');
		} else {
			$data['bcash_title'] = array();
		}

		if (isset($this->request->post['bcash_total'])) {
			$data['bcash_total'] = $this->request->post['bcash_total'];
		} elseif($this->config->has('bcash_total')) {
			$data['bcash_total'] = $this->config->get('bcash_total');
		} else {
			$data['bcash_total'] = '0.01';
		}

		if (isset($this->request->post['bcash_token'])) {
			$data['bcash_token'] = $this->request->post['bcash_token'];
		} else {
			$data['bcash_token'] = $this->config->get('bcash_token');
		}

		if (isset($this->request->post['bcash_email'])) {
			$data['bcash_email'] = $this->request->post['bcash_email'];
		} else {
			$data['bcash_email'] = $this->config->get('bcash_email');
		}

		if (isset($this->request->post['bcash_posfixo'])) {
			$data['bcash_posfixo'] = $this->request->post['bcash_posfixo'];
		} else {
			$data['bcash_posfixo'] = $this->config->get('bcash_posfixo');
		}

		if (isset($this->request->post['bcash_hash'])) {
			$data['bcash_hash'] = $this->request->post['bcash_hash'];
		} else {
			$data['bcash_hash'] = $this->config->get('bcash_hash');
		}

		if (isset($this->request->post['bcash_update_status_alert'])) {
			$data['bcash_update_status_alert'] = $this->request->post['bcash_update_status_alert'];
		} else {
			$data['bcash_update_status_alert'] = $this->config->get('bcash_update_status_alert');
		}

		if (isset($this->request->post['bcash_order_aguardando'])) {
			$data['bcash_order_aguardando'] = $this->request->post['bcash_order_aguardando'];
		} else {
			$data['bcash_order_aguardando'] = $this->config->get('bcash_order_aguardando');
		}

		if (isset($this->request->post['bcash_order_andamento'])) {
			$data['bcash_order_andamento'] = $this->request->post['bcash_order_andamento'];
		} else {
			$data['bcash_order_andamento'] = $this->config->get('bcash_order_andamento');
		}

		if (isset($this->request->post['bcash_order_aprovada'])) {
			$data['bcash_order_aprovada'] = $this->request->post['bcash_order_aprovada'];
		} else {
			$data['bcash_order_aprovada'] = $this->config->get('bcash_order_aprovada');
		}

		if (isset($this->request->post['bcash_order_concluida'])) {
			$data['bcash_order_concluida'] = $this->request->post['bcash_order_concluida'];
		} else {
			$data['bcash_order_concluida'] = $this->config->get('bcash_order_concluida');
		}

		if (isset($this->request->post['bcash_order_cancelada'])) {
			$data['bcash_order_cancelada'] = $this->request->post['bcash_order_cancelada'];
		} else {
			$data['bcash_order_cancelada'] = $this->config->get('bcash_order_cancelada');
		}

		if (isset($this->request->post['bcash_order_disputa'])) {
			$data['bcash_order_disputa'] = $this->request->post['bcash_order_disputa'];
		} else {
			$data['bcash_order_disputa'] = $this->config->get('bcash_order_disputa');
		}

		if (isset($this->request->post['bcash_order_chargeback'])) {
			$data['bcash_order_chargeback'] = $this->request->post['bcash_order_chargeback'];
		} else {
			$data['bcash_order_chargeback'] = $this->config->get('bcash_order_chargeback');
		}

		if (isset($this->request->post['bcash_order_devolvida'])) {
			$data['bcash_order_devolvida'] = $this->request->post['bcash_order_devolvida'];
		} else {
			$data['bcash_order_devolvida'] = $this->config->get('bcash_order_devolvida');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['bcash_geo_zone_id'])) {
			$data['bcash_geo_zone_id'] = $this->request->post['bcash_geo_zone_id'];
		} else {
			$data['bcash_geo_zone_id'] = $this->config->get('bcash_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['bcash_status'])) {
			$data['bcash_status'] = $this->request->post['bcash_status'];
		} else {
			$data['bcash_status'] = $this->config->get('bcash_status');
		}

		if (isset($this->request->post['bcash_sort_order'])) {
			$data['bcash_sort_order'] = $this->request->post['bcash_sort_order'];
		} else {
			$data['bcash_sort_order'] = $this->config->get('bcash_sort_order');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('payment/bcash.tpl', $data));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/bcash')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['bcash_token']) {
			$this->error['token'] = $this->language->get('error_token');
		}

		if (!$this->request->post['bcash_email']) {
			$this->error['email'] = $this->language->get('error_email');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
