<?php
class ControllerModuleIconsocial extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('module/iconsocial');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			// ajusta ordenacao
			if(isset($this->request->post['iconsocial_config']['modules']) && is_array($this->request->post['iconsocial_config']['modules'])){
				$iconsocial_modules = $this->request->post['iconsocial_config']['modules'];

				$sort_order = array();

				foreach ($iconsocial_modules as $key => $value) {
					$sort_order[$key] = $value['sort_order'];
				}

				array_multisort($sort_order, SORT_ASC, $iconsocial_modules);

				$this->request->post['iconsocial_config']['modules'] = $iconsocial_modules;
			}

			$this->model_setting_setting->editSetting('iconsocial', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['button_save']   = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['text_edit']     = $this->language->get('text_edit');
		$data['text_enabled']  = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['entry_status']     = $this->language->get('entry_status');
		$data['entry_title']      = $this->language->get('entry_title');
		$data['entry_width']      = $this->language->get('entry_width');
		$data['entry_height']     = $this->language->get('entry_height');
		$data['entry_style']      = $this->language->get('entry_style');
		$data['entry_style_opt1'] = $this->language->get('entry_style_opt1');
		$data['entry_style_opt2'] = $this->language->get('entry_style_opt2');

		$data['column_title']      = $this->language->get('column_title');
		$data['column_url']        = $this->language->get('column_url');
		$data['column_icon']       = $this->language->get('column_icon');
		$data['column_size']       = $this->language->get('column_size');
		$data['column_status']     = $this->language->get('column_status');
		$data['column_sort_order'] = $this->language->get('column_sort_order');

		$data['button_remove']     = $this->language->get('button_remove');
		$data['button_module_add'] = $this->language->get('button_module_add');

		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('module/iconsocial', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('module/iconsocial', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['iconsocial_config'])) {
			$data['iconsocial_config'] = $this->request->post['iconsocial_config'];
		} elseif ($this->config->get('iconsocial_config')) {
			$data['iconsocial_config'] = $this->config->get('iconsocial_config');
		}else{
			$data['iconsocial_config'] = array();
		}

		$iconsocial_modules = isset($data['iconsocial_config']['modules']) ? $data['iconsocial_config']['modules'] : array();

		$this->load->model('tool/image');

		$data['iconsocial_modules'] = array();

		foreach ($iconsocial_modules as $iconsocial_module) {
			if (is_file(DIR_IMAGE . $iconsocial_module['icon'])) {
				$image = $iconsocial_module['icon'];
				$thumb = $iconsocial_module['icon'];
			} else {
				$image = '';
				$thumb = 'no_image.png';
			}

			$data['iconsocial_modules'][] = array(
				'title'      => $iconsocial_module['title'],
				'link'       => $iconsocial_module['link'],
				'icon'       => $image,
				'thumb'      => $this->model_tool_image->resize($thumb, 100, 100),
				'width'      => $iconsocial_module['width'],
				'height'     => $iconsocial_module['height'],
				'status'     => $iconsocial_module['status'],
				'sort_order' => $iconsocial_module['sort_order'],
			);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('module/iconsocial.tpl', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'module/iconsocial')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (isset($this->request->post['iconsocial_config']['modules'])) {
			$iconsocial_modules = $this->request->post['iconsocial_config']['modules'];

			foreach ($iconsocial_modules as $iconsocial_module) {
				if($iconsocial_module['link'] == ''){
					$this->error['warning'] = $this->language->get('error_link');
					break;
				}
			}
		}

		return !$this->error;
	}
}
