<?php
class ControllerModuleFblikebox extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('module/fblikebox');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/module');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			if (!isset($this->request->get['module_id'])) {
				$this->model_extension_module->addModule('fblikebox', $this->request->post);
			} else {
				$this->model_extension_module->editModule($this->request->get['module_id'], $this->request->post);
			}

			$this->cache->delete('product');

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no']  = $this->language->get('text_no');

		$data['text_screen_all'] = $this->language->get('text_screen_all');
		$data['text_screen_lg']  = $this->language->get('text_screen_lg');
		$data['text_screen_md']  = $this->language->get('text_screen_md');
		$data['text_screen_sm']  = $this->language->get('text_screen_sm');
		$data['text_screen_except_lg'] = $this->language->get('text_screen_except_lg');
		$data['text_screen_except_md'] = $this->language->get('text_screen_except_md');
		$data['text_screen_except_sm'] = $this->language->get('text_screen_except_sm');
		$data['text_columns_nd'] = $this->language->get('text_columns_nd');

		$data['entry_name']          = $this->language->get('entry_name');
		$data['entry_screen']        = $this->language->get('entry_screen');
		$data['entry_columns']       = $this->language->get('entry_columns');
		$data['entry_href']          = $this->language->get('entry_href');
		$data['entry_height']        = $this->language->get('entry_height');
		$data['entry_hide_cover']    = $this->language->get('entry_hide_cover');
		$data['entry_show_facepile'] = $this->language->get('entry_show_facepile');
		$data['entry_show_posts']    = $this->language->get('entry_show_posts');
		$data['entry_small_header']  = $this->language->get('entry_small_header');
		$data['entry_status']        = $this->language->get('entry_status');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['help_title']   = $this->language->get('help_title');
		$data['help_name']    = $this->language->get('help_name');
		$data['help_screen']  = $this->language->get('help_screen');
		$data['help_columns'] = $this->language->get('help_columns');
		$data['help_height']  = $this->language->get('help_height');

		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->error['columns'])) {
			$data['error_columns'] = $this->error['columns'];
		} else {
			$data['error_columns'] = '';
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		if (isset($this->error['href'])) {
			$data['error_href'] = $this->error['href'];
		} else {
			$data['error_href'] = '';
		}

		if (isset($this->error['height'])) {
			$data['error_height'] = $this->error['height'];
		} else {
			$data['error_height'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL')
		);

		if (!isset($this->request->get['module_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('module/fblikebox', 'token=' . $this->session->data['token'], 'SSL')
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('module/fblikebox', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], 'SSL')
			);
		}

		if (!isset($this->request->get['module_id'])) {
			$data['action'] = $this->url->link('module/fblikebox', 'token=' . $this->session->data['token'], 'SSL');
		} else {
			$data['action'] = $this->url->link('module/fblikebox', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], 'SSL');
		}

		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$module_info = $this->model_extension_module->getModule($this->request->get['module_id']);
		}

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (!empty($module_info)) {
			$data['name'] = $module_info['name'];
		} else {
			$data['name'] = '';
		}

		if (isset($this->request->post['title'])) {
			$data['title'] = $this->request->post['title'];
		} elseif (isset($module_info['title']) && !empty($module_info['title'])) {
			$data['title'] = $module_info['title'];
		} else {
			$data['title'] = array();
		}

		if (isset($this->request->post['screen'])) {
			$data['screen'] = $this->request->post['screen'];
		} elseif (isset($module_info['screen']) && !empty($module_info['screen'])) {
			$data['screen'] = $module_info['screen'];
		} else {
			$data['screen'] = '';
		}

		if (isset($this->request->post['columns'])) {
			$data['columns'] = $this->request->post['columns'];
		} elseif (isset($module_info['columns']) && !empty($module_info['columns'])) {
			$data['columns'] = $module_info['columns'];
		} else {
			$data['columns'] = 0;
		}

		if (isset($this->request->post['href'])) {
			$data['href'] = $this->request->post['href'];
		} elseif (!empty($module_info)) {
			$data['href'] = $module_info['href'];
		} else {
			$data['href'] = 'https://www.facebook.com/opencartbrasil';
		}

		if (isset($this->request->post['height'])) {
			$data['height'] = $this->request->post['height'];
		} elseif (!empty($module_info)) {
			$data['height'] = $module_info['height'];
		} else {
			$data['height'] = 200;
		}

		if (isset($this->request->post['hide_cover'])) {
			$data['hide_cover'] = $this->request->post['hide_cover'];
		} elseif (!empty($module_info)) {
			$data['hide_cover'] = $module_info['hide_cover'];
		} else {
			$data['hide_cover'] = 0;
		}

		if (isset($this->request->post['show_facepile'])) {
			$data['show_facepile'] = $this->request->post['show_facepile'];
		} elseif (!empty($module_info)) {
			$data['show_facepile'] = $module_info['show_facepile'];
		} else {
			$data['show_facepile'] = 1;
		}

		if (isset($this->request->post['show_posts'])) {
			$data['show_posts'] = $this->request->post['show_posts'];
		} elseif (!empty($module_info)) {
			$data['show_posts'] = $module_info['show_posts'];
		} else {
			$data['show_posts'] = 1;
		}

		if (isset($this->request->post['small_header'])) {
			$data['small_header'] = $this->request->post['small_header'];
		} elseif (!empty($module_info)) {
			$data['small_header'] = $module_info['small_header'];
		} else {
			$data['small_header'] = 0;
		}

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($module_info)) {
			$data['status'] = $module_info['status'];
		} else {
			$data['status'] = '';
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('module/fblikebox.tpl', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'module/fblikebox')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if (!is_numeric($this->request->post['columns']) || $this->request->post['columns'] < 0 || $this->request->post['columns'] > 6) {
			$this->error['columns'] = $this->language->get('error_columns');
		}

		if (!$this->request->post['href']) {
			$this->error['href'] = $this->language->get('error_href');
		}

		if (!$this->request->post['height']) {
			$this->error['height'] = $this->language->get('error_height');
		}

		return !$this->error;
	}
}
