<?php
class ControllerModuleExibirParcelamento extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('module/exibir_parcelamento');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('exibir_parcelamento', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['button_save']   = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['text_edit']     = $this->language->get('text_edit');
		$data['text_enabled']  = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no']  = $this->language->get('text_no');

		$data['text_texto_a_vista_padrao']        = $this->language->get('text_texto_a_vista_padrao');
		$data['text_texto_sem_juros_padrao']      = $this->language->get('text_texto_sem_juros_padrao');
		$data['text_texto_com_juros_padrao']      = $this->language->get('text_texto_com_juros_padrao');
		$data['text_descricao_lista_padrao']      = $this->language->get('text_descricao_lista_padrao');
		$data['text_descricao_titulo_padrao']     = $this->language->get('text_descricao_titulo_padrao');
		$data['text_texto_link_padrao']           = $this->language->get('text_texto_link_padrao');
		$data['text_titulo_tabela_padrao']        = $this->language->get('text_titulo_tabela_padrao');
		$data['text_descricao_tabela_padrao']     = $this->language->get('text_descricao_tabela_padrao');
		$data['text_texto_juros_padrao']          = $this->language->get('text_texto_juros_padrao');
		$data['text_texto_parcela_minima_padrao'] = $this->language->get('text_texto_parcela_minima_padrao');
		$data['text_texto_observacoes_padrao']    = $this->language->get('text_texto_observacoes_padrao');

		$data['text_calculo_juros_2'] = $this->language->get('text_calculo_juros_2');
		$data['text_calculo_juros_1'] = $this->language->get('text_calculo_juros_1');
		$data['text_calculo_juros_0'] = $this->language->get('text_calculo_juros_0');

		$data['tab_module_num'] = $this->language->get('tab_module_num');
		$data['tab_module_add'] = $this->language->get('tab_module_add');

		$data['entry_minimo']               = $this->language->get('entry_minimo');
		$data['entry_maximo_parcelas']      = $this->language->get('entry_maximo_parcelas');
		$data['entry_parcelas_sem_juros']   = $this->language->get('entry_parcelas_sem_juros');
		$data['entry_juros']                = $this->language->get('entry_juros');
		$data['entry_tipo_juros']           = $this->language->get('entry_tipo_juros');
		$data['entry_parcela_minima']       = $this->language->get('entry_parcela_minima');
		$data['entry_texto_a_vista']        = $this->language->get('entry_texto_a_vista');
		$data['entry_texto_sem_juros']      = $this->language->get('entry_texto_sem_juros');
		$data['entry_texto_com_juros']      = $this->language->get('entry_texto_com_juros');
		$data['entry_descricao_lista']      = $this->language->get('entry_descricao_lista');
		$data['entry_descricao_titulo']     = $this->language->get('entry_descricao_titulo');
		$data['entry_texto_link']           = $this->language->get('entry_texto_link');
		$data['entry_titulo_tabela']        = $this->language->get('entry_titulo_tabela');
		$data['entry_descricao_tabela']     = $this->language->get('entry_descricao_tabela');
		$data['entry_texto_juros']          = $this->language->get('entry_texto_juros');
		$data['entry_texto_parcela_minima'] = $this->language->get('entry_texto_parcela_minima');
		$data['entry_texto_observacoes']    = $this->language->get('entry_texto_observacoes');
		$data['entry_listagem']             = $this->language->get('entry_listagem');
		$data['entry_resumo_sem_juros']     = $this->language->get('entry_resumo_sem_juros');
		$data['entry_status']               = $this->language->get('entry_status');
		$data['entry_sort_order']           = $this->language->get('entry_sort_order');

		$data['help_minimo']               = $this->language->get('help_minimo');
		$data['help_maximo_parcelas']      = $this->language->get('help_maximo_parcelas');
		$data['help_parcelas_sem_juros']   = $this->language->get('help_parcelas_sem_juros');
		$data['help_juros']                = $this->language->get('help_juros');
		$data['help_tipo_juros']           = $this->language->get('help_tipo_juros');
		$data['help_parcela_minima']       = $this->language->get('help_parcela_minima');
		$data['help_texto_a_vista']        = $this->language->get('help_texto_a_vista');
		$data['help_texto_sem_juros']      = $this->language->get('help_texto_sem_juros');
		$data['help_texto_com_juros']      = $this->language->get('help_texto_com_juros');
		$data['help_descricao_lista']      = $this->language->get('help_descricao_lista');
		$data['help_descricao_titulo']     = $this->language->get('help_descricao_titulo');
		$data['help_texto_link']           = $this->language->get('help_texto_link');
		$data['help_titulo_tabela']        = $this->language->get('help_titulo_tabela');
		$data['help_descricao_tabela']     = $this->language->get('help_descricao_tabela');
		$data['help_texto_juros']          = $this->language->get('help_texto_juros');
		$data['help_texto_parcela_minima'] = $this->language->get('help_texto_parcela_minima');
		$data['help_texto_observacoes']    = $this->language->get('help_texto_observacoes');
		$data['help_listagem']             = $this->language->get('help_listagem');
		$data['help_resumo_sem_juros']     = $this->language->get('help_resumo_sem_juros');

		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('module/exibir_parcelamento', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('module/exibir_parcelamento', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['exibir_parcelamento_config'])) {
			$data['modules'] = $this->request->post['exibir_parcelamento_config'];
		} elseif ($this->config->get('exibir_parcelamento_config')) {
			$data['modules'] = $this->config->get('exibir_parcelamento_config');
		} else {
			$data['modules'] = array();
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('module/exibir_parcelamento.tpl', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'module/exibir_parcelamento')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (isset($this->request->post['exibir_parcelamento_config'])) {
			foreach($this->request->post['exibir_parcelamento_config'] as $k => $module){
				if(!is_numeric($module['minimo'])){
					$this->error['warning'] = $this->language->get('error_minimo');
				}

				if(!is_numeric($module['maximo_parcelas']) || $module['maximo_parcelas'] <= 1){
					$this->error['warning'] = $this->language->get('error_maximo_parcelas');
				}

				if(!is_numeric($module['parcelas_sem_juros']) || $module['parcelas_sem_juros'] <= 0){
					$this->error['warning'] = $this->language->get('error_parcelas_sem_juros');
				}

				if(!is_numeric($module['juros'])){
					$this->error['warning'] = $this->language->get('error_juros');
				}

				if(!is_array($module['texto_a_vista'])){
					$this->error['warning'] = $this->language->get('error_texto_a_vista');
				}else{

					foreach($module['texto_a_vista'] as $i => $texto_a_vista){
						$module['texto_a_vista'][$i] = trim($texto_a_vista);

						if($module['texto_a_vista'][$i] == ''){
							$this->error['warning'] = $this->language->get('error_texto_a_vista');
						}
					}

					$this->request->post['exibir_parcelamento_config'][$k]['texto_a_vista'] = $module['texto_a_vista'];
				}

				if(!is_array($module['texto_sem_juros'])){
					$this->error['warning'] = $this->language->get('error_texto_sem_juros');
				}else{

					foreach($module['texto_sem_juros'] as $i => $texto_sem_juros){
						$module['texto_sem_juros'][$i] = trim($texto_sem_juros);

						if($module['texto_sem_juros'][$i] == ''){
							$this->error['warning'] = $this->language->get('error_texto_sem_juros');
						}
					}

					$this->request->post['exibir_parcelamento_config'][$k]['texto_sem_juros'] = $module['texto_sem_juros'];
				}

				if(!is_array($module['texto_com_juros'])){
					$this->error['warning'] = $this->language->get('error_texto_com_juros');
				}else{

					foreach($module['texto_com_juros'] as $i => $texto_com_juros){
						$module['texto_com_juros'][$i] = trim($texto_com_juros);

						if($module['texto_com_juros'][$i] == ''){
							$this->error['warning'] = $this->language->get('error_texto_com_juros');
						}
					}

					$this->request->post['exibir_parcelamento_config'][$k]['texto_com_juros'] = $module['texto_com_juros'];
				}

				if(!is_array($module['descricao_tabela'])){
					$this->error['warning'] = $this->language->get('error_descricao_tabela');
				}else{

					foreach($module['descricao_tabela'] as $i => $descricao_tabela){
						$module['descricao_tabela'][$i] = trim($descricao_tabela);

						if($module['descricao_tabela'][$i] == ''){
							$this->error['warning'] = $this->language->get('error_descricao_tabela');
						}
					}

					$this->request->post['exibir_parcelamento_config'][$k]['descricao_tabela'] = $module['descricao_tabela'];
				}

				if(!is_numeric($module['sort_order'])){
					$this->request->post['exibir_parcelamento_config'][$k]['sort_order'] = 0;
				}
			}
		}

		return !$this->error;
	}
}
