<?php
class ControllerModuleExibirDescontos extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('module/exibir_descontos');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('exibir_descontos', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['button_save']   = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['text_edit']     = $this->language->get('text_edit');
		$data['text_enabled']  = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no']  = $this->language->get('text_no');

		$data['text_descricao_padrao']       = $this->language->get('text_descricao_padrao');
		$data['text_descricao_lista_padrao'] = $this->language->get('text_descricao_lista_padrao');

		$data['tab_module_num'] = $this->language->get('tab_module_num');
		$data['tab_module_add'] = $this->language->get('tab_module_add');

		$data['entry_desconto']        = $this->language->get('entry_desconto');
		$data['entry_minimo']          = $this->language->get('entry_minimo');
		$data['entry_descricao']       = $this->language->get('entry_descricao');
		$data['entry_listagem']        = $this->language->get('entry_listagem');
		$data['entry_descricao_lista'] = $this->language->get('entry_descricao_lista');
		$data['entry_status']          = $this->language->get('entry_status');
		$data['entry_sort_order']      = $this->language->get('entry_sort_order');

		$data['help_desconto']        = $this->language->get('help_desconto');
		$data['help_minimo']          = $this->language->get('help_minimo');
		$data['help_descricao']       = $this->language->get('help_descricao');
		$data['help_listagem']        = $this->language->get('help_listagem');
		$data['help_descricao_lista'] = $this->language->get('help_descricao_lista');

		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['desconto'])) {
			$data['error_desconto'] = $this->error['desconto'];
		} else {
			$data['error_desconto'] = '';
		}

		if (isset($this->error['minimo'])) {
			$data['error_minimo'] = $this->error['minimo'];
		} else {
			$data['error_minimo'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('module/exibir_descontos', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['action'] = $this->url->link('module/exibir_descontos', 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['exibir_descontos_config'])) {
			$data['modules'] = $this->request->post['exibir_descontos_config'];
		} elseif ($this->config->get('exibir_descontos_config')) {
			$data['modules'] = $this->config->get('exibir_descontos_config');
		} else {
			$data['modules'] = array();
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('module/exibir_descontos.tpl', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'module/exibir_descontos')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (isset($this->request->post['exibir_descontos_config'])) {
			foreach($this->request->post['exibir_descontos_config'] as $k => $module){
				if(!is_numeric($module['desconto']) || $module['desconto'] <= 0){
					$this->error['warning'] = $this->language->get('error_desconto');
				}

				if(!is_numeric($module['minimo'])){
					$this->error['warning'] = $this->language->get('error_minimo');
				}

				if(!is_array($module['descricao'])){
					$this->error['warning'] = $this->language->get('error_descricao');
				}else{

					foreach($module['descricao'] as $i => $descricao){
						$module['descricao'][$i] = trim($descricao);

						if($module['descricao'][$i] == ''){
							$this->error['warning'] = $this->language->get('error_descricao');
						}
					}

					$this->request->post['exibir_descontos_config'][$k]['descricao'] = $module['descricao'];
				}

				if(!is_numeric($module['sort_order'])){
					$this->request->post['exibir_descontos_config'][$k]['sort_order'] = 0;
				}
			}
		}

		return !$this->error;
	}
}
